% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\name{calc_diff_x_pos}
\alias{calc_diff_x_pos}
\title{Calculate difference of x_position of commom word between two sentences}
\usage{
calc_diff_x_pos(df, s_id, term, x_pos, i, j)
}
\arguments{
\item{df}{A dataframe analysed by MeCab}

\item{s_id}{A String to specify sentence}

\item{term, x_pos}{A String to specify term and x_position}

\item{i, j}{A integer to specify sentence number}
}
\value{
A numeric
}
\description{
Calculate difference of x_position of commom word between two sentences
}
\examples{
s1 <- letters[1:4]
s2 <- letters[3:6]
term <- c(s1, s2)
df <- tibble::tibble(
        sentence = rep(1:2, c(length(s1), length(s2))), 
        term = term,
        x = seq_along(term))
s_id <- "sentence"
term <- "term"
x_pos <- "x"
calc_diff_x_pos(df, s_id, term, x_pos, 1, 2)

intersect(1:3 ,4:6)

}
