% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.survFitVarExp.R
\name{plot.survFitVarExp}
\alias{plot.survFitVarExp}
\title{Plotting method for \code{survFit} objects}
\usage{
\method{plot}{survFitVarExp}(
  x,
  xlab = "Time",
  ylab = "Survival probability",
  main = NULL,
  spaghetti = FALSE,
  one.plot = FALSE,
  adddata = TRUE,
  mcmc_size = NULL,
  scales = "fixed",
  addConfInt = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{survFit}.}

\item{xlab}{A label for the \eqn{X}-axis, by default \code{Time}.}

\item{ylab}{A label for the \eqn{Y}-axis, by default \code{Survival probability}.}

\item{main}{A main title for the plot.}

\item{spaghetti}{if \code{TRUE}, draws a set of survival curves using
parameters drawn from the posterior distribution}

\item{one.plot}{if \code{TRUE}, draws all the estimated curves in
one plot instead of one plot per concentration.}

\item{adddata}{if \code{TRUE}, adds the observed data to the plot.}

\item{mcmc_size}{A numerical value refering by default to the size of the mcmc in object \code{survFit}.
This option is specific to \code{survFitVarExp} objects for which computing time may be long.
\code{mcmc_size} can be used to reduce the number of mcmc samples in order to speed up
the computation.}

\item{scales}{Shape the scale of axis. Default is \code{"fixed"}, but can be \code{"free"}, or free
in only one dimension \code{"free_x"}, \code{"free_y"}. (See \code{ggplot2} documentation
 for more details.)}

\item{addConfInt}{If \code{TRUE}, add a \eqn{95\%} confidence interval on observed data from a binomial test}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\value{
a plot of class \code{ggplot}
}
\description{
This is the generic \code{plot} S3 method for the
\code{survFit}.  It plots the fit obtained for each
concentration profile in the original dataset.
}
\details{
The fitted curves represent the \strong{estimated survival probability} as a function
of time for each concentration profile.
The black dots depict the \strong{observed survival
probability} at each time point. Note that since our model does not take
inter-replicate variability into consideration, replicates are systematically
pooled in this plot.
The function plots both 95\% binomial credible intervals for the estimated survival
probability (by default the grey area around the fitted curve) and 95\% binomial confidence
intervals for the observed survival probability (as black segments if
\code{adddata = TRUE}).
Both types of intervals are taken at the same level. Typically
a good fit is expected to display a large overlap between the two types of  intervals.
If \code{spaghetti = TRUE}, the credible intervals are represented by two
dotted lines limiting the credible band, and a spaghetti plot is added to this band.
This spaghetti plot consists of the representation of simulated curves using parameter values
sampled in the posterior distribution (10\% of the MCMC chains are randomly
taken for this sample).
}
\examples{

# (1) Load the survival data
data("propiconazole_pulse_exposure")

# (2) Create an object of class "survData"
dataset <- survData(propiconazole_pulse_exposure)

\donttest{
# (3) Run the survFit function
out <- survFit(dataset , model_type = "SD")

# (4) Summary look the estimated values (parameters)
summary(out)

# (5) Plot the fitted curve
plot(out, adddata = FALSE)

# (6) Plot the fitted curve with ggplot style and CI as spaghetti
plot(out, spaghetti = TRUE)
}

}
\keyword{plot}
