% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.survFitCstExp.R
\name{print.survFitCstExp}
\alias{print.survFitCstExp}
\title{Print of \code{survFit} object}
\usage{
\method{print}{survFitCstExp}(x, ...)
}
\arguments{
\item{x}{An object of class \code{survFitCstExp}}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\value{
print the model text and the Jags Computing information
}
\description{
This is the generic \code{print} S3 method for the \code{survFitCstExp} class.
It prints the underlying JAGS model and some information on the Bayesian 
inference procedure.
}
\examples{
# (1) Load the data
data(propiconazole)

# (2) Create an object of class 'survData'
dat <- survData(propiconazole)

\donttest{
# (3) Run the survFit function with TKTD model 'SD' or 'IT' 
out <- survFit(dat, quiet = TRUE, model_type="SD")

# (4) Print the survFit object
print(out)
}

}
\keyword{print}
