% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotModel.R
\name{plotModel}
\alias{plotModel}
\title{Plot a regression model}
\usage{
plotModel(mod, ...)
}
\arguments{
\item{mod}{A model of type \code{\link{lm}} or \code{\link{glm}}}

\item{\dots}{arguments passed to \code{\link{xyplot}} or \code{rgl::plot3d}.}
}
\value{
A lattice or ggplot2 graphics object.
}
\description{
Visualize a regression model amid the data that generated it.
}
\details{
The goal of this function is to assist with visualization
of statistical models. Namely, to plot the model on top of the data
from which the model was fit.

The primary plot type is a scatter plot.  The x-axis can be assigned
to one of the predictors in the model.  Additional predictors are thought
of as co-variates.  The data and fitted curves are partitioned by
these covariates.  When the number of components to this partition is large,
a random subset of the fitted curves is displayed to avoid visual clutter.

If the model was fit on one quantitative variable (e.g. SLR), then
a scatter plot is drawn, and the model is realized as parallel or
non-parallel lines, depending on whether interaction terms are present.

Eventually we hope to support 3-d visualizations of models with 2 quantitative
predictors using the \code{rgl} package.


Currently, only linear regression models and
generalized linear regression models are supported.
}
\examples{
require(mosaic)

mod <- lm( mpg ~ factor(cyl), data = mtcars)
plotModel(mod)

# SLR
mod <- lm( mpg ~ wt, data = mtcars)
plotModel(mod, pch = 19)

# parallel slopes
mod <- lm( mpg ~ wt + factor(cyl), data=mtcars)
plotModel(mod)

# multiple categorical vars
mod <- lm( mpg ~ wt + factor(cyl) + factor(vs) + factor(am), data = mtcars)
plotModel(mod)
plotModel(mod, key = ~am)

# interaction
mod <- lm( mpg ~ wt + factor(cyl) + wt:factor(cyl), data = mtcars)
plotModel(mod)

# polynomial terms
mod <- lm( mpg ~ wt + I(wt^2), data = mtcars)
plotModel(mod)

# GLM
mod <- glm(vs ~ wt, data=mtcars, family = 'binomial')
plotModel(mod)

# GLM with interaction
mod <- glm(vs ~ wt + factor(cyl), data=mtcars, family = 'binomial')
plotModel(mod)
# 3D model
mod <- lm( mpg ~ wt + hp, data = mtcars)
plotModel(mod)

# parallel planes
mod <- lm( mpg ~ wt + hp + factor(cyl) + factor(vs), data = mtcars)
plotModel(mod)

# interaction planes
# not work -- need better logic in function
mod <- lm( mpg ~ wt + hp + wt * factor(cyl), data = mtcars)
plotModel(mod)
}
\author{
Ben Baumer, Galen Long, Randall Pruim
}
\seealso{
\code{\link{plotPoints}}, \code{\link{plotFun}}
}

