% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupwiseModels.R
\name{MSPE}
\alias{MSPE}
\title{Mean Squared Prediction Error}
\usage{
MSPE(model, data, LL = TRUE)
}
\arguments{
\item{model}{a model produced by \code{lm}, \code{glm}, or \code{gwm}.}

\item{data}{a data frame.}

\item{LL}{if \code{TRUE}, for categorical responses replace mean square error 
with minus mean log likelihood}
}
\description{
A one-step calculation of mean square prediction error
}
\details{
For categorical responses, the mean square prediction error is not ideal.  Better
to use the likelhood.  \code{LL = TRUE} (the default) turns the calculation into the mean log likelihood
per case, negated so that large values mean poor predictions
}
\examples{
HELP <- HELPrct \%>\% sample_frac(.3)
MSPE( gwm( age ~ sex, data = HELP), HELPrct)
MSPE( gwm( age ~ 1, data = HELP), HELPrct)
MSPE( gwm( age ~ sex + homeless, data = HELP), HELPrct)
MSPE( gwm( sex ~ 1, data = HELP), HELPrct)
MSPE( gwm( sex ~ homeless, data = HELP), HELPrct)
MSPE( gwm( sex ~ homeless + substance, data = HELP), HELPrct)
}

