% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tally}
\alias{tally}
\alias{tally.default}
\alias{tally.tbl}
\title{Tabulate categorical data}
\usage{
tally(x, ...)

\method{tally}{tbl}(x, wt, sort = FALSE, ..., envir = parent.frame())

\method{tally}{default}(x, data = parent.frame(), format = c("default",
  "count", "proportion", "percent"), margins = FALSE, quiet = TRUE, subset,
  useNA = "ifany", ...)
}
\arguments{
\item{x}{an object}

\item{data}{a data frame or environment in which evaluation occurs.
Note that the default is \code{data=parent.frame()}.  This makes it convenient to
use this function interactively by treating the working envionment as if it were
a data frame.  But this may not be appropriate for programming uses.
When programming, it is best to use an explicit \code{data} argument
-- ideally supplying a data frame that contains the variables mentioned}

\item{format}{a character string describing the desired format of the results.
One of \code{'default'}, \code{'count'}, \code{'proportion'}, or \code{'percent'}.
In case of \code{'default'}, counts are used unless there is a condition, in
which case proportions are used instead.}

\item{subset}{an expression evaluating to a logical vector used to select a subset of \code{data}}

\item{quiet}{a logical indicating whether messages about order in which marginal distributions
are calculated should be surpressed.  See \code{\link{addmargins}}.}

\item{margins}{a logical indicating whether marginal distributions should be displayed.}

\item{useNA}{as in \code{\link{table}}, but the default here is \code{"ifany"}.}

\item{envir}{an environment in which to evaluate}

\item{...}{additional arguments passed to \code{\link{table}}}

\item{wt}{for weighted tallying,
see \code{\link[dplyr]{tally}} in \pkg{dplyr}}

\item{sort}{a logical,
see \code{\link[dplyr]{tally}} in \pkg{dplyr}}
}
\description{
Tabulate categorical data
}
\details{
The \pkg{dplyr} package also exports a \code{\link[dplyr]{tally}} function.  If \code{x} inherits
from class \code{"tbl"}, then \pkg{dplyr}'s \code{tally} is called.  This makes it
easier to have the two package coexist.
}
\examples{
if (require(mosaicData)) {
tally( ~ substance, data=HELPrct)
tally( ~ substance & sex , data=HELPrct)
tally( sex ~ substance, data=HELPrct)   # equivalent to tally( ~ sex | substance, ... )
tally( ~ substance | sex , data=HELPrct)
tally( ~ substance | sex , data=HELPrct, format='count')
tally( ~ substance & sex , data=HELPrct, format='percent')
# force NAs to show up
tally( ~ sex, data=HELPrct, useNA="always")
# show NAs if any are there
tally( ~ link, data=HELPrct)
# ignfore the NAs
tally( ~ link, data=HELPrct, useNA="no")
}
}

