% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{rflip}
\alias{rflip}
\alias{print.cointoss}
\alias{nflip}
\title{Tossing Coins}
\usage{
rflip(
  n = 1,
  prob = 0.5,
  quiet = FALSE,
  verbose = !quiet,
  summarize = FALSE,
  summarise = summarize
)

\method{print}{cointoss}(x, ...)

nflip(n = 1, prob = 0.5, ...)
}
\arguments{
\item{n}{the number of coins to toss}

\item{prob}{probability of heads on each toss}

\item{quiet}{a logical.  If \code{TRUE}, less verbose output is used.}

\item{verbose}{a logical.  If \code{TRUE}, more verbose output is used.}

\item{summarize}{if \code{TRUE}, return a summary (as a data frame).}

\item{summarise}{alternative spelling for \code{summarize}.}

\item{x}{an object}

\item{\dots}{additional arguments}
}
\value{
for \code{rflip}, a cointoss object

for \code{nflip}, a numeric vector
}
\description{
These functions simplify simulating coin tosses for those (students primarily)
who are not yet familiar with the binomial distributions or just like this syntax
and verbosity better.
}
\examples{
rflip(10)
rflip(10, prob = 1/6, quiet = TRUE)
rflip(10, prob = 1/6, summarize = TRUE)
do(5) * rflip(10)
as.numeric(rflip(10))
nflip(10)
}
