% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numD.R
\name{numD}
\alias{numD}
\title{Numerical Derivatives}
\usage{
numD(formula, ..., .hstep = NULL, add.h.control = FALSE)
}
\arguments{
\item{formula}{a mathematical expression (see examples and \code{\link{plotFun}})}

\item{...}{additional parameters, typically default values for mathematical parameters}

\item{.hstep}{numerical finite-difference step (default is 1e-6 or 1e-4 for first and second-order derivatives, respectively)}

\item{add.h.control}{arranges the returned function to have a \code{.hstep} argument that can be used to demonstrate convergence and error}
}
\value{
a function implementing the derivative as a finite-difference approximation
}
\description{
Constructs the numerical derivatives of mathematical expressions
}
\details{
Uses a simple finite-difference scheme to evaluate the derivative.  The function created
will not contain a formula for the derivative.  Instead, the original function is stored
at the time the derivative is constructed and that original function is re-evaluated at the
finitely-spaced points of an interval.  If you redefine the original function, that won't affect
any derivatives that were already defined from it.
Numerical derivatives, particularly high-order ones, are unstable.  The finite-difference parameter
\code{.hstep} is set, by default, to give reasonable results for first- and second-order derivatives.
It's tweaked a bit so that taking a second derivative by differentiating a first derivative
will give reasonably accurate results.  But,
if taking a second derivative, much better to do it in one step to preserve numerical accuracy.
}
\note{
WARNING: In the expressions, do not use variable names beginning with a dot, particularly \code{.f} or \code{.h}
}
\examples{
g = numD( a*x^2 + x*y ~ x, a=1)
g(x=2,y=10)
gg = numD( a*x^2 + x*y ~ x&x, a=1)
gg(x=2,y=10)
ggg = numD( a*x^2 + x*y ~ x&y, a=1)
ggg(x=2,y=10)
h = numD( g(x=x,y=y,a=a) ~ y, a=1)
h(x=2,y=10)
f = numD( sin(x)~x, add.h.control=TRUE)
# plotFun( f(3,.hstep=h)~h, hlim=range(.00000001,.000001))
# ladd( panel.abline(cos(3),0))

}
\author{
Daniel Kaplan (\email{kaplan@macalester.edu})
}
