% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numD.R
\name{numD}
\alias{numD}
\title{Numerical Derivatives}
\usage{
numD(tilde, ..., .h = NULL)
}
\arguments{
\item{tilde}{a mathematical expression (see examples and \code{\link{plotFun}})}

\item{\dots}{additional parameters, typically default values for mathematical parameters}

\item{.h}{numerical step size to enforce.}
}
\value{
a function implementing the derivative as a finite-difference approximation.
This has a second argument, \code{.h}, that allow the finite-difference to be set when evaluating
the function. The default values are set for reasonable numerical precision.
}
\description{
Constructs the numerical derivatives of mathematical expressions
}
\details{
Uses a simple finite-difference scheme to evaluate the derivative.  The function created
will not contain a formula for the derivative.  Instead, the original function is stored
at the time the derivative is constructed and that original function is re-evaluated at the
finitely-spaced points of an interval.  If you redefine the original function, that won't affect
any derivatives that were already defined from it.
Numerical derivatives, particularly high-order ones, are unstable.  The finite-difference parameter
\code{.h} is set, by default, to give reasonable results for first- and second-order derivatives.
It's tweaked a bit so that taking a second derivative by differentiating a first derivative
will give reasonably accurate results.  But,
if taking a second derivative, much better to do it in one step to preserve numerical accuracy.
}
\note{
WARNING: In the expressions, do not use variable names beginning with a dot, particularly \code{.f} or \code{.h}
}
\examples{
g = numD( a*x^2 + x*y ~ x, a=1)
g(x=2,y=10)
gg = numD( a*x^2 + x*y ~ x&x, a=1)
gg(x=2,y=10)
ggg = numD( a*x^2 + x*y ~ x&y, a=1)
ggg(x=2,y=10)
h = numD( g(x=x,y=y,a=a) ~ y, a=1)
h(x=2,y=10)
f = numD( sin(x)~x)
# slice_plot( f(3,.h=hlim)~h, bounds(h=.00000001 :000001)) \%>\% gf_hline(yintercept = cos(3))

}
\author{
Daniel Kaplan (\email{kaplan@macalester.edu})
}
