% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfapply.R
\name{dfapply}
\alias{dfapply}
\title{apply-type function for data frames}
\usage{
dfapply(data, FUN, select = TRUE, ...)
}
\arguments{
\item{data}{data frame}

\item{FUN}{a function to apply to (some) variables in the data frame}

\item{select}{a logical, character (naming variables), or numeric vector or a
function used to select variables to which \code{FUN} is applied.  If a function,
it should take a vector as input and return a single logical. See examples.}

\item{\dots}{arguments passed along to \code{FUN}}
}
\description{
An \code{apply}-type function for data frames.
}
\examples{
dfapply(iris, mean, select = is.numeric)
dfapply(iris, mosaic::favstats, select = c(TRUE, TRUE, FALSE, FALSE, FALSE))
dfapply(iris, mean, select = c(1,2))
dfapply(iris, mean, select = c("Sepal.Length", "Petal.Length"))
if (require(mosaicData)) {
  dfapply(HELPrct, table, select = is.factor)
  do.call(rbind, dfapply(HELPrct, mean, select = is.numeric))
}
}
\seealso{
\code{\link[=apply]{apply()}},
\code{\link[=sapply]{sapply()}},
\code{\link[=tapply]{tapply()}},
\code{\link[=lapply]{lapply()}},
\code{\link[=inspect]{inspect()}}
}
