% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasetsDoc.R
\docType{data}
\name{KidsFeet}
\alias{KidsFeet}
\title{Foot measurements in children}
\format{A data frame with 39 observations on the following variables.
  \itemize{
    \item{\code{name}} {a factor with levels corresponding to the name of each child}
    \item{\code{birthmonth}} {the month of birth}
    \item{\code{birthyear}} {the year of birth}
    \item{\code{length}} {length of longer foot (in cm)}
    \item{\code{width}} {width of longer foot (in cm)}
    \item{\code{sex}} {a factor with levels \code{B} \code{G}}
    \item{\code{biggerfoot}} {a factor with levels \code{L} \code{R}}
    \item{\code{domhand}} {a factor with levels \code{L} \code{R}}
  }}
\usage{
data(KidsFeet)
}
\description{
These data were collected by a statistician, Mary C. Meyer, in a
fourth grade classroom in Ann Arbor, MI, in October 1997.  They are a
convenience sample --- the kids who were in the fourth grade.
}
\details{
Quoted from the source: ``From a very young age, shoes for boys tend to be wider than shoes for girls.  Is this because boys have wider feet, or because it is assumed that
girls, even in elementary school, are willing to sacrifice comfort for fashion?
To assess the former, a statistician measures kids' feet.''
}
\examples{
data(KidsFeet)

}
\references{
Mary C. Meyer (2006) ``Wider Shoes for Wider Feet?''
\emph{Journal of Statistics Education} 14(1),
\url{www.amstat.org/publications/jse/v14n1/datasets.meyer.html}
}
\keyword{datasets}

