% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_eval.R
\name{mod_eval}
\alias{mod_eval}
\title{Evaluate a model for specified inputs}
\usage{
mod_eval(model = NULL, data = NULL, append = TRUE, interval = c("none",
  "prediction", "confidence"), nlevels = 2, bootstrap = 0, ...,
  on_training = FALSE)
}
\arguments{
\item{model}{the model to display graphically}

\item{data}{optional set of cases from which to extract levels for explanatory variables}

\item{append}{flag whether to include the inputs to the model along with the calculated
model value in the output. Default: \code{TRUE}.}

\item{interval}{the type of interval to use: "none", "confidence", "prediction". But not all
types are available for all model architectures.}

\item{nlevels}{how many levels to construct for input variables. (default: 3)
For quantitative variables, this is a suggestion; an attempt is made to have the levels equally spaced. If you're dissatisfied
with the result, use the ... to specify exactly what levels you want for any variable.}

\item{bootstrap}{if > 1, the number of bootstrap trials to run to construct a
standard error on the model output for each value of the inputs. This is an alternative to
\code{interval}; you can't use both.}

\item{...}{arguments about or values at which to evaluate the model or the kind of output to be passed along to predict().
Unlike \code{data =} the variables given in \code{at =} or \code{...} will be crossed, so that
the evaluation will occur at all combinations of the various levels.}

\item{on_training}{flag whether to use the training data for evaluation. Only needed
when there are random terms, e.g. from \code{rand()}, \code{shuffle()}, .... See details.}
}
\value{
A dataframe containing both the explanatory variable inputs and
the resulting model output (in the \code{model_value} field). This differs from the output
of \code{predict()}, which for many model classes/architectures may be a vector or matrix.

A data frame containing both the inputs to the model and the corresponding outputs.
}
\description{
Find the model outputs for specified inputs. This is equivalent to the
generic \code{predict()} function, except it will choose sensible values
by default.  This simplifies getting a quick look at model values.
}
\details{
There are four distinct ways to specify the values at which the model is to be evaluated.
(1) Look for some "typical values" in the data to create a handful of inputs. This is useful for
getting a quick look at what the output of the model looks like. This is the default behavior. (2) Using \code{data =} to a dataframe containing the explanatory variables will evaluate the model
at all of the cases contained in that dataframe. (3) Setting input variables explicitly by using
arguments of the form var_name = values, e.g. \code{sex = "F"}. If not all input variables are specified in
this way, the ones that are not will have values set per (1). All combinations of the various variables
will be created. See the \code{nlevels} argument. (4) Evaluating the model on the training data.
There are two ways to do this. The first is
to set the \code{data} argument to the same data frame used to train the model. The second
is to use the \code{on_training = TRUE} argument. These are equivalent unless there is
some random component among the explanatory terms, as with \code{mosaic::rand()}, \code{mosaic::shuffle()} and so on.
}
\examples{
\dontrun{
mod1 <- lm(wage ~ age * sex + sector, data = mosaicData::CPS85)
mod_eval(mod1)
mod2 <- glm(married == "Married" ~ age + sex * sector,
            data = mosaicData::CPS85, family = "binomial")
mod_eval(mod2, nlevels = 2)
mod_eval(mod2, nlevels = 2, sex = "F") 
}
}
