% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{cpts.bootstrap}
\alias{cpts.bootstrap}
\title{Bootstrapping estimated change points}
\usage{
cpts.bootstrap(mcpts, N_reps, alpha = 0.05)
}
\arguments{
\item{mcpts}{an object of class \code{mosum.cpts}, \code{multiscale.cpts}
or \code{multiscale.bottomUp.cpts}}

\item{N_reps}{number of bootstrap replications}

\item{alpha}{numeric value in (0,1), such that the (1-alpha_CI)-confidence bootstrap intervals are computed}
}
\value{
object of class \code{cpts.bootstrap}, containing the following fields:
   \item{CI}{data frame of five columns, containing the estimated changepoints (column \code{cpt}),
   the pointwise alpha confidence intervals (columns \code{pCI_l} and \code{pCI_r})
   and the uniform alpha confidence intervals (columns \code{uCI_l} and \code{uCI_r})}
   \item{bootstrap_replicates}{matrix of dimension N_reps times q (where q denotes the estimated 
number of changes in mcpts), containing
N_reps bootstrapped replicates of the estimated changepoint locations}
}
\description{
Obtain bootstrap replicates of changepoint estimators
}
\details{
See the referenced literature for further details
}
\examples{
set.seed(1337)
x <- piecewiseStationary_timeSeries(lengths=rep(100,3), means=c(0,3,1), sds=rep(1,3))
mcpts <- mosum.cpts(x, G=40)
cpts_boot <- cpts.bootstrap(mcpts, 5000)
print(cpts_boot$CI)
}
\references{
A. Meier, C. Kirch and H. Cho.
\emph{mosum: A Package for Moving Sums in Change Point Analysis.}
Unpublished manuscript, 2018+.

H. Cho and C. Kirch.
\emph{Multiple change-point detection via multiscale MOSUM procedure with localized pruning.}
Unpublished manuscript, 2018+.
}
