context("Motif adjacency matrices")

test_that("build_motif_adjacency_matrix returns correct
           unweighted functional matrix", {

  # test case
  adj_mat_dense <- demonstration_graph()$adj_mat_dense
  adj_mat_sparse <- demonstration_graph()$adj_mat_sparse

  # correct answers
  ans <- list()

  ans$Ms <- drop0(matrix(c(
    0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    1,  0,  1,  0,  2,  2,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  2,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,
    1,  2,  0,  0,  0,  2,  0,  0,  1,  1,  0,  0,
    0,  2,  2,  0,  2,  0,  1,  0,  0,  1,  1,  0,
    0,  0,  1,  1,  0,  1,  0,  2,  0,  0,  1,  1,
    0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  0,  0,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  1,  1,  0,  0,  1,  0,  0,  0,
    0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$Md <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  1,  1,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M1 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  2,  3,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  2,  0,  0,  0,  3,  0,  0,  0,  1,  0,  0,
    0,  3,  1,  0,  3,  0,  1,  0,  0,  1,  1,  0,
    0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  1,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M2 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  2,  0,  6,  8,  0,  0,  0,  0,  0,  0,
    0,  2,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  6,  0,  0,  0,  7,  0,  0,  0,  1,  0,  0,
    0,  8,  2,  0,  7,  0,  0,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M3 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  6,  7,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  6,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,
    0,  7,  1,  0,  6,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M4 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M5 <- drop0(matrix(c(
    0,  2,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,
    2,  0,  3,  0,  8,  9,  0,  0,  0,  0,  0,  0,
    0,  3,  0,  0,  0,  5,  2,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    2,  8,  0,  0,  0,  7,  0,  0,  1,  2,  0,  0,
    0,  9,  5,  0,  7,  0,  2,  0,  0,  1,  0,  0,
    0,  0,  2,  0,  0,  2,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  0,  0,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  2,  1,  0,  0,  1,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M6 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  3,  4,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  2,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  3,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,
    0,  4,  2,  0,  3,  0,  1,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M7 <- drop0(matrix(c(
    0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    1,  0,  1,  0,  4,  4,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    1,  4,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,
    0,  4,  1,  0,  3,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M8 <- drop0(matrix(c(
    0,  4,  1,  0,  5,  2,  0,  0,  1,  1,  0,  0,
    4,  0,  4,  0,  8,  7,  0,  0,  1,  1,  1,  0,
    1,  4,  0,  1,  2,  5,  3,  1,  0,  0,  1,  0,
    0,  0,  1,  0,  0,  1,  3,  1,  0,  0,  0,  0,
    5,  8,  2,  0,  0,  8,  0,  0,  4,  4,  1,  0,
    2,  7,  5,  1,  8,  0,  3,  1,  1,  1,  3,  0,
    0,  0,  3,  3,  0,  3,  0,  3,  0,  0,  0,  0,
    0,  0,  1,  1,  0,  1,  3,  0,  0,  0,  0,  0,
    1,  1,  0,  0,  4,  1,  0,  0,  0,  1,  0,  0,
    1,  1,  0,  0,  4,  1,  0,  0,  1,  0,  0,  0,
    0,  1,  1,  0,  1,  3,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M9 <- drop0(matrix(c(
    0,  3,  0,  0,  3,  2,  0,  0,  0,  0,  0,  0,
    3,  0,  5,  0, 11, 14,  1,  0,  1,  2,  1,  0,
    0,  5,  0,  0,  3, 10,  5,  1,  0,  1,  2,  1,
    0,  0,  0,  0,  0,  0,  3,  1,  0,  0,  1,  1,
    3, 11,  3,  0,  0, 15,  1,  0,  3,  5,  1,  0,
    2, 14, 10,  0, 15,  0,  9,  1,  2,  7,  7,  1,
    0,  1,  5,  3,  1,  9,  0,  5,  0,  0,  6,  4,
    0,  0,  1,  1,  0,  1,  5,  0,  0,  0,  1,  1,
    0,  1,  0,  0,  3,  2,  0,  0,  0,  2,  0,  0,
    0,  2,  1,  0,  5,  7,  0,  0,  2,  0,  1,  0,
    0,  1,  2,  1,  1,  7,  6,  1,  0,  1,  0,  0,
    0,  0,  1,  1,  0,  1,  4,  1,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M10 <- drop0(matrix(c(
    0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    1,  0,  3,  0,  4,  7,  2,  0,  0,  1,  0,  0,
    0,  3,  0,  0,  1,  6,  3,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    1,  4,  1,  0,  0,  6,  1,  0,  1,  2,  0,  0,
    0,  7,  6,  0,  6,  0,  5,  0,  0,  4,  0,  0,
    0,  2,  3,  0,  1,  5,  0,  2,  0,  1,  2,  2,
    0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  1,
    0,  0,  0,  0,  1,  0,  0,  0,  0,  1,  0,  0,
    0,  1,  1,  0,  2,  4,  1,  0,  1,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  2,  1,  0,  0,  0,  1,
    0,  0,  0,  0,  0,  0,  2,  1,  0,  0,  1,  0
  ), nrow = 12, byrow = TRUE))

  ans$M11 <- drop0(matrix(c(
    0,  3,  0,  0,  3,  2,  0,  0,  0,  0,  0,  0,
    3,  0,  4,  0, 11, 11,  0,  0,  1,  1,  1,  0,
    0,  4,  0,  0,  3,  6,  1,  1,  0,  0,  1,  0,
    0,  0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,
    3, 11,  3,  0,  0, 12,  0,  0,  2,  2,  1,  0,
    2, 11,  6,  0, 12,  0,  1,  1,  1,  1,  3,  0,
    0,  0,  1,  1,  0,  1,  0,  3,  0,  0,  0,  0,
    0,  0,  1,  1,  0,  1,  3,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  2,  1,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  2,  1,  0,  0,  0,  0,  0,  0,
    0,  1,  1,  0,  1,  3,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M12 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  3,  0,  6, 11,  1,  0,  0,  1,  0,  0,
    0,  3,  0,  0,  2,  8,  2,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  6,  2,  0,  0, 10,  1,  0,  0,  1,  0,  0,
    0, 11,  8,  0, 10,  0,  4,  0,  0,  3,  0,  0,
    0,  1,  2,  0,  1,  4,  0,  2,  0,  0,  1,  1,
    0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  1,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  1,  1,  0,  1,  3,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M13 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  3,  4,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  1,  2,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  3,  1,  0,  0,  4,  0,  0,  0,  0,  0,  0,
    0,  4,  2,  0,  4,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$Mcoll <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  2,  2,  2,  0,  0,  1,  0,  0,
    0,  1,  0,  0,  1,  0,  1,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  2,  1,  0,  0,  1,  1,  0,  1,  1,  0,  0,
    0,  2,  0,  0,  1,  0,  1,  0,  0,  0,  0,  0,
    0,  2,  1,  0,  1,  1,  0,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,
    0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    0,  1,  1,  0,  1,  0,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  1,
    0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  1,  0
  ), nrow = 12, byrow = TRUE))

  ans$Mexpa <- drop0(matrix(c(
    0,  1,  1,  0,  1,  2,  0,  0,  1,  1,  0,  0,
    1,  0,  1,  0,  1,  1,  0,  0,  1,  1,  1,  0,
    1,  1,  0,  1,  2,  2,  0,  1,  0,  0,  1,  0,
    0,  0,  1,  0,  0,  1,  0,  1,  0,  0,  0,  0,
    1,  1,  2,  0,  0,  1,  0,  0,  0,  0,  1,  0,
    2,  1,  2,  1,  1,  0,  0,  1,  1,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  1,  1,  0,  1,  0,  0,  0,  0,  0,  0,
    1,  1,  0,  0,  0,  1,  0,  0,  0,  1,  0,  0,
    1,  1,  0,  0,  0,  1,  0,  0,  1,  0,  0,  0,
    0,  1,  1,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  # compare calculations with answers
  motifs <- get_motif_names()
  for (i in seq_len(length(motifs))) {

    mam_densematrix_densemethod <- build_motif_adjacency_matrix(
      adj_mat_dense, motifs[i], "func", "unweighted", "dense")
    mam_sparsematrix_densemethod <- build_motif_adjacency_matrix(
      adj_mat_sparse, motifs[i], "func", "unweighted", "dense")
    mam_densematrix_sparsemethod <- build_motif_adjacency_matrix(
      adj_mat_dense, motifs[i], "func", "unweighted", "sparse")
    mam_sparsematrix_sparsemethod <- build_motif_adjacency_matrix(
      adj_mat_sparse, motifs[i], "func", "unweighted", "sparse")

    expect_equal(mam_densematrix_densemethod, ans[[motifs[i]]])
    expect_equal(mam_sparsematrix_densemethod, ans[[motifs[i]]])
    expect_equal(mam_densematrix_sparsemethod, ans[[motifs[i]]])
    expect_equal(mam_sparsematrix_sparsemethod, ans[[motifs[i]]])
  }

})

test_that("build_motif_adjacency_matrix returns correct
           unweighted structural matrix", {

  # test case
  adj_mat_dense <- demonstration_graph()$adj_mat_dense
  adj_mat_sparse <- demonstration_graph()$adj_mat_sparse

  # correct answers
  ans <- list()

  ans$Ms <- drop0(matrix(c(
    0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    1,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,
    1,  0,  0,  0,  0,  0,  0,  0,  1,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  1,  1,  0,
    0,  0,  1,  1,  0,  1,  0,  0,  0,  0,  1,  1,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  0,  0,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  1,  1,  0,  0,  1,  0,  0,  0,
    0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$Md <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  1,  1,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M1 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  1,  0,
    0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  1,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M2 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  1,  0,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  1,  0,  0,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M3 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M4 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M5 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  0,  0,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  1,  0,  0,  0,  1,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M6 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M7 <- drop0(matrix(c(
    0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M8 <- drop0(matrix(c(
    0,  1,  1,  0,  2,  0,  0,  0,  1,  1,  0,  0,
    1,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    1,  1,  0,  1,  0,  0,  1,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  0,  1,  2,  0,  0,  0,  0,  0,
    2,  0,  0,  0,  0,  0,  0,  0,  1,  1,  0,  0,
    0,  0,  0,  1,  0,  0,  1,  0,  0,  0,  0,  0,
    0,  0,  1,  2,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    1,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M9 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  1,
    0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  1,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  1,  2,  1,  1,
    0,  0,  2,  2,  0,  1,  0,  0,  0,  0,  2,  3,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  1,  0,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  0,  2,  0,  0,  1,  0,  1,  0,
    0,  0,  1,  1,  0,  1,  2,  0,  0,  1,  0,  0,
    0,  0,  1,  1,  0,  1,  3,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M10 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  0,  0,  1,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  1,  0,  0,
    0,  1,  1,  0,  0,  1,  0,  0,  0,  1,  1,  1,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  1,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  1,  0
  ), nrow = 12, byrow = TRUE))

  ans$M11 <- drop0(matrix(c(
    0,  1,  0,  0,  1,  2,  0,  0,  0,  0,  0,  0,
    1,  0,  1,  0,  3,  2,  0,  0,  1,  1,  1,  0,
    0,  1,  0,  0,  1,  1,  1,  1,  0,  0,  1,  0,
    0,  0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,
    1,  3,  1,  0,  0,  3,  0,  0,  2,  1,  1,  0,
    2,  2,  1,  0,  3,  0,  1,  1,  1,  0,  3,  0,
    0,  0,  1,  1,  0,  1,  0,  3,  0,  0,  0,  0,
    0,  0,  1,  1,  0,  1,  3,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  2,  1,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    0,  1,  1,  0,  1,  3,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M12 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  2,  1,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  0,  1,  0,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,
    0,  2,  1,  0,  1,  0,  2,  0,  0,  2,  0,  0,
    0,  1,  0,  0,  1,  2,  0,  2,  0,  0,  1,  1,
    0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  1,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  1,  1,  0,  0,  2,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M13 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  1,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$Mcoll <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  1,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0
  ), nrow = 12, byrow = TRUE))

  ans$Mexpa <- drop0(matrix(c(
    0,  0,  1,  0,  0,  0,  0,  0,  1,  1,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    1,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  1,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  # compare calculations with answers
  motifs <- get_motif_names()
  for (i in seq_len(length(motifs))) {

    mam_densematrix_densemethod <- build_motif_adjacency_matrix(
      adj_mat_dense, motifs[i], "struc", "unweighted", "dense")
    mam_sparsematrix_densemethod <- build_motif_adjacency_matrix(
      adj_mat_sparse, motifs[i], "struc", "unweighted", "dense")
    mam_densematrix_sparsemethod <- build_motif_adjacency_matrix(
      adj_mat_dense, motifs[i], "struc", "unweighted", "sparse")
    mam_sparsematrix_sparsemethod <- build_motif_adjacency_matrix(
      adj_mat_sparse, motifs[i], "struc", "unweighted", "sparse")

    expect_equal(mam_densematrix_densemethod, ans[[motifs[i]]])
    expect_equal(mam_sparsematrix_densemethod, ans[[motifs[i]]])
    expect_equal(mam_densematrix_sparsemethod, ans[[motifs[i]]])
    expect_equal(mam_sparsematrix_sparsemethod, ans[[motifs[i]]])
  }

})

test_that("build_motif_adjacency_matrix returns correct
           mean-weighted functional matrix", {

  # test case
  adj_mat_dense <- demonstration_graph()$adj_mat_dense
  adj_mat_sparse <- demonstration_graph()$adj_mat_sparse

  # correct answers
  ans <- list()

  ans$Ms <- drop0(matrix(c(
    0,  2,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
    2,  0,  3,  0, 11, 15,  0,  0,  0,  0,  0,  0,
    0,  3,  0,  0,  0, 19, 11,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,
    4, 11,  0,  0,  0, 27,  0,  0, 18, 19,  0,  0,
    0, 15, 19,  0, 27,  0, 15,  0,  0, 20, 21,  0,
    0,  0, 11, 12,  0, 15,  0, 33,  0,  0, 22, 23,
    0,  0,  0,  0,  0,  0, 33,  0,  0,  0,  0,  0,
    0,  0,  0,  0, 18,  0,  0,  0,  0, 24,  0,  0,
    0,  0,  0,  0, 19, 20,  0,  0, 24,  0,  0,  0,
    0,  0,  0,  0,  0, 21, 22,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 23,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$Md <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0, 11, 15,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 19,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 11,  0,  0,  0, 27,  0,  0,  0,  0,  0,  0,
    0, 15, 19,  0, 27,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 33,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 33,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 2

  ans$M1 <- drop0(matrix(c(
    0,  0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,  0, 20,  0,  53,  73,  0,  0,  0,  0,  0,  0,
    0, 20,  0,  0,   0,  20,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0, 53,  0,  0,   0, 105,  0,  0,  0, 52,  0,  0,
    0, 73, 20,  0, 105,   0, 58,  0,  0, 52, 58,  0,
    0,  0,  0,  0,   0,  58,  0,  0,  0,  0, 58,  0,
    0,  0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  52,  52,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,  58, 58,  0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 3

  ans$M2 <- drop0(matrix(c(
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0, 57,  0, 212, 269,  0,  0,  0,  0,  0,  0,
    0,  57,  0,  0,   0,  57,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0, 212,  0,  0,   0, 278,  0,  0,  0, 66,  0,  0,
    0, 269, 57,  0, 278,   0,  0,  0,  0, 66,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,  66,  66,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 4

  ans$M3 <- drop0(matrix(c(
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0, 37,  0, 265, 302,  0,  0,  0,  0,  0,  0,
    0,  37,  0,  0,   0,  37,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0, 265,  0,  0,   0, 265,  0,  0,  0,  0,  0,  0,
    0, 302, 37,  0, 265,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 5

  ans$M4 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0, 53, 53,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 53,  0,  0,  0, 53,  0,  0,  0,  0,  0,  0,
    0, 53,  0,  0, 53,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 6

  ans$M5 <- drop0(matrix(c(
    0,  23,   0,  0,  23,   0,  0,  0,  0,   0,  0,  0,
   23,   0,  60,  0, 182, 219,  0,  0,  0,   0,  0,  0,
    0,  60,   0,  0,   0, 131, 71,  0,  0,   0,  0,  0,
    0,   0,   0,  0,   0,   0,  0,  0,  0,   0,  0,  0,
   23, 182,   0,  0,   0, 212,  0,  0, 61, 114,  0,  0,
    0, 219, 131,  0, 212,   0, 71,  0,  0,  53,  0,  0,
    0,   0,  71,  0,   0,  71,  0,  0,  0,   0,  0,  0,
    0,   0,   0,  0,   0,   0,  0,  0,  0,   0,  0,  0,
    0,   0,   0,  0,  61,   0,  0,  0,  0,  61,  0,  0,
    0,   0,   0,  0, 114,  53,  0,  0, 61,   0,  0,  0,
    0,   0,   0,  0,   0,   0,  0,  0,  0,   0,  0,  0,
    0,   0,   0,  0,   0,   0,  0,  0,  0,   0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 3

  ans$M6 <- drop0(matrix(c(
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0, 30,  0, 106, 136,  0,  0,  0,  0,  0,  0,
    0,  30,  0,  0,   0,  75, 45,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0, 106,  0,  0,   0, 106,  0,  0,  0,  0,  0,  0,
    0, 136, 75,  0, 106,   0, 45,  0,  0,  0,  0,  0,
    0,   0, 45,  0,   0,  45,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 4

  ans$M7 <- drop0(matrix(c(
    0,  17,  0,  0,  17,   0,  0,  0,  0,  0,  0,  0,
   17,   0, 27,  0, 123, 133,  0,  0,  0,  0,  0,  0,
    0,  27,  0,  0,   0,  27,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
   17, 123,  0,  0,   0, 106,  0,  0,  0,  0,  0,  0,
    0, 133, 27,  0, 106,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 4

  ans$M8 <- drop0(matrix(c(
    0,  32,   5,  0,  80,  28,  0,  0,  22,  23,  0,  0,
   32,   0,  41,  0, 126, 118,  0,  0,  23,  24, 28,  0,
    5,  41,   0, 23,  31, 105, 77, 28,   0,   0, 30,  0,
    0,   0,  23,  0,   0,  27, 79, 29,   0,   0,  0,  0,
   80, 126,  31,  0,   0, 192,  0,  0, 114, 117, 34,  0,
   28, 118, 105, 27, 192,   0, 85, 32,  32,  33, 92,  0,
    0,   0,  77, 79,   0,  85,  0, 89,   0,   0,  0,  0,
    0,   0,  28, 29,   0,  32, 89,  0,   0,   0,  0,  0,
   22,  23,   0,  0, 114,  32,  0,  0,   0,  37,  0,  0,
   23,  24,   0,  0, 117,  33,  0,  0,  37,   0,  0,  0,
    0,  28,  30,  0,  34,  92,  0,  0,   0,   0,  0,  0,
    0,   0,   0,  0,   0,   0,  0,  0,   0,   0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 2

  ans$M9 <- drop0(matrix(c(
    0,  26,   0,  0,  34,  26,   0,   0,  0,   0,   0,   0,
   26,   0,  65,  0, 180, 250,  22,   0, 24,  52,  29,   0,
    0,  65,   0,  0,  54, 208, 139,  27,  0,  29,  64,  34,
    0,   0,   0,  0,   0,   0,  97,  28,  0,   0,  34,  35,
   34, 180,  54,  0,   0, 367,  28,   0, 97, 171,  35,   0,
   26, 250, 208,  0, 367,   0, 280,  31, 75, 245, 252,  38,
    0,  22, 139, 97,  28, 280,   0, 165,  0,   0, 222, 147,
    0,   0,  27, 28,   0,  31, 165,   0,  0,   0,  39,  40,
    0,  24,   0,  0,  97,  75,   0,   0,  0,  86,   0,   0,
    0,  52,  29,  0, 171, 245,   0,   0, 86,   0,  41,   0,
    0,  29,  64, 34,  35, 252, 222,  39,  0,  41,   0,   0,
    0,   0,  34, 35,   0,  38, 147,  40,  0,   0,   0,   0
  ), nrow = 12, byrow = TRUE)) / 2

  ans$M10 <- drop0(matrix(c(
    0,   6,   0,  0,   6,   0,   0,  0,  0,   0,  0,  0,
    6,   0,  44,  0,  59, 134,  37,  0,  0,  28,  0,  0,
    0,  44,   0,  0,  24, 129,  59,  0,  0,  30,  0,  0,
    0,   0,   0,  0,   0,   0,   0,  0,  0,   0,  0,  0,
    6,  59,  24,  0,   0, 140,  29,  0, 43,  77,  0,  0,
    0, 134, 129,  0, 140,   0, 132,  0,  0, 127,  0,  0,
    0,  37,  59,  0,  29, 132,   0, 77,  0,  35, 83, 84,
    0,   0,   0,  0,   0,   0,  77,  0,  0,   0, 38, 39,
    0,   0,   0,  0,  43,   0,   0,  0,  0,  43,  0,  0,
    0,  28,  30,  0,  77, 127,  35,  0, 43,   0,  0,  0,
    0,   0,   0,  0,   0,   0,  83, 38,  0,   0,  0, 45,
    0,   0,   0,  0,   0,   0,  84, 39,  0,   0, 45,  0
  ), nrow = 12, byrow = TRUE)) / 2

  ans$M11 <- drop0(matrix(c(
    0,  45,   0,  0,  59,  48,   0,   0,  0,  0,   0,  0,
   45,   0,  82,  0, 260, 280,   0,   0, 29, 30,  36,  0,
    0,  82,   0,  0,  82, 176,  44,  44,  0,  0,  40,  0,
    0,   0,   0,  0,   0,   0,  45,  45,  0,  0,   0,  0,
   59, 260,  82,  0,   0, 397,   0,   0, 74, 76,  48,  0,
   48, 280, 176,  0, 397,   0,  48,  48, 45, 46, 124,  0,
    0,   0,  44, 45,   0,  48,   0, 137,  0,  0,   0,  0,
    0,   0,  44, 45,   0,  48, 137,   0,  0,  0,   0,  0,
    0,  29,   0,  0,  74,  45,   0,   0,  0,  0,   0,  0,
    0,  30,   0,  0,  76,  46,   0,   0,  0,  0,   0,  0,
    0,  36,  40,  0,  48, 124,   0,   0,  0,  0,   0,  0,
    0,   0,   0,  0,   0,   0,   0,   0,  0,  0,   0,  0
  ), nrow = 12, byrow = TRUE)) / 3

  ans$M12 <- drop0(matrix(c(
    0,   0,   0,  0,   0,   0,   0,   0,  0,   0,  0,  0,
    0,   0,  74,  0, 159, 298,  30,   0,  0,  35,  0,  0,
    0,  74,   0,  0,  70, 247,  64,   0,  0,  39,  0,  0,
    0,   0,   0,  0,   0,   0,   0,   0,  0,   0,  0,  0,
    0, 159,  70,  0,   0, 318,  42,   0,  0,  47,  0,  0,
    0, 298, 247,  0, 318,   0, 136,   0,  0, 121,  0,  0,
    0,  30,  64,  0,  42, 136,   0, 111,  0,   0, 55, 56,
    0,   0,   0,  0,   0,   0, 111,   0,  0,   0, 55, 56,
    0,   0,   0,  0,   0,   0,   0,   0,  0,   0,  0,  0,
    0,  35,  39,  0,  47, 121,   0,   0,  0,   0,  0,  0,
    0,   0,   0,  0,   0,   0,  55,  55,  0,   0,  0,  0,
    0,   0,   0,  0,   0,   0,  56,  56,  0,   0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 3

  ans$M13 <- drop0(matrix(c(
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0, 34,  0, 106, 140,  0,  0,  0,  0,  0,  0,
    0,  34,  0,  0,  46,  80,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0, 106, 46,  0,   0, 152,  0,  0,  0,  0,  0,  0,
    0, 140, 80,  0, 152,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 4

  ans$Mcoll <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0, 18,  0, 28, 31, 37,  0,  0, 28,  0,  0,
    0, 18,  0,  0, 24,  0, 25,  0,  0, 30,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 28, 24,  0,  0, 12, 29,  0, 43, 34,  0,  0,
    0, 31,  0,  0, 12,  0, 20,  0,  0,  0,  0,  0,
    0, 37, 25,  0, 29, 20,  0,  0,  0, 35,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 38, 39,
    0,  0,  0,  0, 43,  0,  0,  0,  0,  0,  0,  0,
    0, 28, 30,  0, 34,  0, 35,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 38,  0,  0,  0, 45,
    0,  0,  0,  0,  0,  0,  0, 39,  0,  0, 45,  0
  ), nrow = 12, byrow = TRUE)) / 2

  ans$Mexpa <- drop0(matrix(c(
    0,  9,  5,  0,  8, 28,  0,  0, 22, 23,  0,  0,
    9,  0, 16,  0, 20, 19,  0,  0, 23, 24, 28,  0,
    5, 16,  0, 23, 31, 37,  0, 28,  0,  0, 30,  0,
    0,  0, 23,  0,  0, 27,  0, 29,  0,  0,  0,  0,
    8, 20, 31,  0,  0, 14,  0,  0,  0,  0, 34,  0,
   28, 19, 37, 27, 14,  0,  0, 32, 32, 33,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0, 28, 29,  0, 32,  0,  0,  0,  0,  0,  0,
   22, 23,  0,  0,  0, 32,  0,  0,  0, 37,  0,  0,
   23, 24,  0,  0,  0, 33,  0,  0, 37,  0,  0,  0,
    0, 28, 30,  0, 34,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 2

  # compare calculations with answers
  motifs <- get_motif_names()
  for (i in seq_len(length(motifs))) {

    mam_densematrix_densemethod <- build_motif_adjacency_matrix(
      adj_mat_dense, motifs[i], "func", "mean", "dense")
    mam_sparsematrix_densemethod <- build_motif_adjacency_matrix(
      adj_mat_sparse, motifs[i], "func", "mean", "dense")
    mam_densematrix_sparsemethod <- build_motif_adjacency_matrix(
      adj_mat_dense, motifs[i], "func", "mean", "sparse")
    mam_sparsematrix_sparsemethod <- build_motif_adjacency_matrix(
      adj_mat_sparse, motifs[i], "func", "mean", "sparse")

    expect_equal(mam_densematrix_densemethod, ans[[motifs[i]]])
    expect_equal(mam_sparsematrix_densemethod, ans[[motifs[i]]])
    expect_equal(mam_densematrix_sparsemethod, ans[[motifs[i]]])
    expect_equal(mam_sparsematrix_sparsemethod, ans[[motifs[i]]])
  }

})

test_that("build_motif_adjacency_matrix returns correct
           mean-weighted structural matrix", {

  # test case
  adj_mat_dense <- demonstration_graph()$adj_mat_dense
  adj_mat_sparse <- demonstration_graph()$adj_mat_sparse

  # correct answers
  ans <- list()

  ans$Ms <- drop0(matrix(c(
    0,  2,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
    2,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  3,  0,  0,  0,  0, 11,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,
    4,  0,  0,  0,  0,  0,  0,  0, 18, 19,  0,  0,
    0,  0,  0,  0,  0,  0, 15,  0,  0, 20, 21,  0,
    0,  0, 11, 12,  0, 15,  0,  0,  0,  0, 22, 23,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0, 18,  0,  0,  0,  0, 24,  0,  0,
    0,  0,  0,  0, 19, 20,  0,  0, 24,  0,  0,  0,
    0,  0,  0,  0,  0, 21, 22,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 23,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$Md <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0, 11, 15,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 19,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 11,  0,  0,  0, 27,  0,  0,  0,  0,  0,  0,
    0, 15, 19,  0, 27,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 33,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 33,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 2

  ans$M1 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 58,  0,  0,  0, 58,  0,
    0,  0,  0,  0,  0, 58,  0,  0,  0,  0, 58,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 58, 58,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 3

  ans$M2 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 66,  0,  0,  0, 66,  0,  0,
    0,  0,  0,  0, 66,  0,  0,  0,  0, 66,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0, 66, 66,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 4

  ans$M3 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0, 37,  0,  0, 37,  0,  0,  0,  0,  0,  0,
    0, 37,  0,  0,  0, 37,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 37, 37,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 5

  ans$M4 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0, 53, 53,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 53,  0,  0,  0, 53,  0,  0,  0,  0,  0,  0,
    0, 53,  0,  0, 53,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 6

  ans$M5 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0, 61, 61,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0, 61,  0,  0,  0,  0, 61,  0,  0,
    0,  0,  0,  0, 61,  0,  0,  0, 61,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 3

  ans$M6 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 45, 45,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0, 45,  0,  0,  0, 45,  0,  0,  0,  0,  0,
    0,  0, 45,  0,  0, 45,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 4

  ans$M7 <- drop0(matrix(c(
    0, 17,  0,  0, 17,  0,  0,  0,  0,  0,  0,  0,
   17,  0,  0,  0, 17,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   17, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 4

  ans$M8 <- drop0(matrix(c(
    0,  5,  5,  0, 45,  0,  0,  0, 22, 23,  0,  0,
    5,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    5,  5,  0, 23,  0,  0, 23,  0,  0,  0,  0,  0,
    0,  0, 23,  0,  0, 27, 50,  0,  0,  0,  0,  0,
   45,  0,  0,  0,  0,  0,  0,  0, 22, 23,  0,  0,
    0,  0,  0, 27,  0,  0, 27,  0,  0,  0,  0,  0,
    0,  0, 23, 50,  0, 27,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   22,  0,  0,  0, 22,  0,  0,  0,  0,  0,  0,  0,
   23,  0,  0,  0, 23,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 2

  ans$M9 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,   0,
    0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,   0,
    0,  0,  0,  0,  0,  0,  67,  0,  0,  0, 33,  34,
    0,  0,  0,  0,  0,  0,  69,  0,  0,  0, 34,  35,
    0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,   0,
    0,  0,  0,  0,  0,  0,  38,  0, 44, 85, 41,  38,
    0,  0, 67, 69,  0, 38,   0,  0,  0,  0, 67, 107,
    0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,   0,
    0,  0,  0,  0,  0, 44,   0,  0,  0, 44,  0,   0,
    0,  0,  0,  0,  0, 85,   0,  0, 44,  0, 41,   0,
    0,  0, 33, 34,  0, 41,  67,  0,  0, 41,  0,   0,
    0,  0, 34, 35,  0, 38, 107,  0,  0,  0,  0,   0
  ), nrow = 12, byrow = TRUE)) / 2

  ans$M10 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0, 14,  0,  0,  0, 14,  0,  0,  0,  0,  0,
    0, 14,  0,  0,  0,  0, 14,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 35,  0,  0, 35,  0,  0,
    0, 14, 14,  0,  0, 35,  0,  0,  0, 35, 45, 45,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 35, 35,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 45,  0,  0,  0,  0, 45,
    0,  0,  0,  0,  0,  0, 45,  0,  0,  0, 45,  0
  ), nrow = 12, byrow = TRUE)) / 2

  ans$M11 <- drop0(matrix(c(
    0, 17,  0,  0,  31,  48,   0,   0,  0,  0,   0,  0,
   17,  0, 14,  0,  73,  53,   0,   0, 29, 30,  36,  0,
    0, 14,  0,  0,  14,  40,  44,  44,  0,  0,  40,  0,
    0,  0,  0,  0,   0,   0,  45,  45,  0,  0,   0,  0,
   31, 73, 14,  0,   0, 124,   0,   0, 74, 30,  48,  0,
   48, 53, 40,  0, 124,   0,  48,  48, 45,  0, 124,  0,
    0,  0, 44, 45,   0,  48,   0, 137,  0,  0,   0,  0,
    0,  0, 44, 45,   0,  48, 137,   0,  0,  0,   0,  0,
    0, 29,  0,  0,  74,  45,   0,   0,  0,  0,   0,  0,
    0, 30,  0,  0,  30,   0,   0,   0,  0,  0,   0,  0,
    0, 36, 40,  0,  48,  124,  0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,   0,  0
  ), nrow = 12, byrow = TRUE)) / 3

  ans$M12 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 65,  30,   0,  0, 35,  0,  0,
    0,  0,  0,  0,  0, 39,   0,   0,  0, 39,  0,  0,
    0,  0,  0,  0,  0,  0,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 42,  42,   0,  0,  0,  0,  0,
    0, 65, 39,  0, 42,  0,  72,   0,  0, 74,  0,  0,
    0, 30,  0,  0, 42, 72,   0, 111,  0,  0, 55, 56,
    0,  0,  0,  0,  0,  0, 111,   0,  0,  0, 55, 56,
    0,  0,  0,  0,  0,  0,   0,   0,  0,  0,  0,  0,
    0, 35, 39,  0,  0, 74,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  55,  55,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  56,  56,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 3

  ans$M13 <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0, 46, 46,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0, 46,  0,  0, 46,  0,  0,  0,  0,  0,  0,
    0,  0, 46,  0, 46,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 4

  ans$Mcoll <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 14,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 14,  0,  0,  0,  0,  0,  0,  0, 35,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 35,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,  0
  ), nrow = 12, byrow = TRUE)) / 2

  ans$Mexpa <- drop0(matrix(c(
    0,  0,  5,  0,  0,  0,  0,  0, 22, 23,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    5,  0,  0, 23,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  23,  0,  0, 27,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0, 27,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   22,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   23,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE)) / 2

  # compare calculations with answers
  motifs <- get_motif_names()
  for (i in seq_len(length(motifs))) {

    mam_densematrix_densemethod <- build_motif_adjacency_matrix(
      adj_mat_dense, motifs[i], "struc", "mean", "dense")
    mam_sparsematrix_densemethod <- build_motif_adjacency_matrix(
      adj_mat_sparse, motifs[i], "struc", "mean", "dense")
    mam_densematrix_sparsemethod <- build_motif_adjacency_matrix(
      adj_mat_dense, motifs[i], "struc", "mean", "sparse")
    mam_sparsematrix_sparsemethod <- build_motif_adjacency_matrix(
      adj_mat_sparse, motifs[i], "struc", "mean", "sparse")

    expect_equal(mam_densematrix_densemethod, ans[[motifs[i]]])
    expect_equal(mam_sparsematrix_densemethod, ans[[motifs[i]]])
    expect_equal(mam_densematrix_sparsemethod, ans[[motifs[i]]])
    expect_equal(mam_sparsematrix_sparsemethod, ans[[motifs[i]]])
  }

})

test_that("build_motif_adjacency_matrix returns correct
           product-weighted functional matrix", {

  # test case
  adj_mat_dense <- demonstration_graph()$adj_mat_dense
  adj_mat_sparse <- demonstration_graph()$adj_mat_sparse

  # correct answers
  ans <- list()

  ans$Ms <- drop0(matrix(c(
    0,  2,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
    2,  0,  3,  0, 11, 15,  0,  0,  0,  0,  0,  0,
    0,  3,  0,  0,  0, 19, 11,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,
    4, 11,  0,  0,  0, 27,  0,  0, 18, 19,  0,  0,
    0, 15, 19,  0, 27,  0, 15,  0,  0, 20, 21,  0,
    0,  0, 11, 12,  0, 15,  0, 33,  0,  0, 22, 23,
    0,  0,  0,  0,  0,  0,  33,  0,  0,  0,  0,  0,
    0,  0,  0,  0, 18,  0,  0,  0,  0, 24,  0,  0,
    0,  0,  0,  0, 19, 20,  0,  0, 24,  0,  0,  0,
    0,  0,  0,  0,  0, 21, 22,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 23,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$Md <- drop0(matrix(c(
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,  30,  56,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,  90,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0,
    0, 30,  0,  0,   0, 182,   0,   0,  0,  0,  0,  0,
    0, 56, 90,  0, 182,   0,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0, 272,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0, 272,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M1 <- drop0(matrix(c(
    0,    0,   0,  0,    0,    0,    0,  0,  0,    0,    0,  0,
    0,    0, 210,  0, 1108, 1318,    0,  0,  0,    0,    0,  0,
    0,  210,   0,  0,    0,  210,    0,  0,  0,    0,    0,  0,
    0,    0,   0,  0,    0,    0,    0,  0,  0,    0,    0,  0,
    0, 1108,   0,  0,    0, 6048,    0,  0,  0, 4940,    0,  0,
    0, 1318, 210,  0, 6048,    0, 6930,  0,  0, 4940, 6930,  0,
    0,    0,   0,  0,    0, 6930,    0,  0,  0,    0, 6930,  0,
    0,    0,   0,  0,    0,    0,    0,  0,  0,    0,    0,  0,
    0,    0,   0,  0,    0,    0,    0,  0,  0,    0,    0,  0,
    0,    0,   0,  0, 4940, 4940,    0,  0,  0,    0,    0,  0,
    0,    0,   0,  0,    0, 6930, 6930,  0,  0,    0,    0,  0,
    0,    0,   0,  0,    0,    0,    0,  0,  0,    0,    0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M2 <- drop0(matrix(c(
    0,     0,    0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,     0, 3570,  0, 29328, 32898,  0,  0,  0,     0,  0,  0,
    0,  3570,    0,  0,     0,  3570,  0,  0,  0,     0,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0, 29328,    0,  0,     0, 98488,  0,  0,  0, 69160,  0,  0,
    0, 32898, 3570,  0, 98488,     0,  0,  0,  0, 69160,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,     0,    0,  0, 69160, 69160,  0,  0,  0,     0,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,     0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M3 <- drop0(matrix(c(
    0,      0,     0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0, 15120,  0, 239372, 254492,  0,  0,  0,  0,  0,  0,
    0,  15120,     0,  0,      0,  15120,  0,  0,  0,  0,  0,  0,
    0,      0,     0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0, 239372,     0,  0,      0, 239372,  0,  0,  0,  0,  0,  0,
    0, 254492, 15120,  0, 239372,      0,  0,  0,  0,  0,  0,  0,
    0,      0,     0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,     0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,     0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,     0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,     0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,     0,  0,      0,      0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M4 <- drop0(matrix(c(
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0, 305760, 305760,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0, 305760,  0,  0,      0, 305760,  0,  0,  0,  0,  0,  0,
    0, 305760,  0,  0, 305760,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M5 <- drop0(matrix(c(
    0,   88,    0,  0,    88,    0,    0,  0,    0,     0,  0,  0,
   88,    0,  645,  0,  3435, 3992,    0,  0,    0,     0,  0,  0,
    0,  645,    0,  0,     0, 3780, 3135,  0,    0,     0,  0,  0,
    0,    0,    0,  0,     0,    0,    0,  0,    0,     0,  0,  0,
   88, 3435,    0,  0,     0, 8667,    0,  0, 8208, 13528,  0,  0,
    0, 3992, 3780,  0,  8667,    0, 3135,  0,    0,  5320,  0,  0,
    0,    0, 3135,  0,     0, 3135,    0,  0,    0,     0,  0,  0,
    0,    0,    0,  0,     0,    0,    0,  0,    0,     0,  0,  0,
    0,    0,    0,  0,  8208,    0,    0,  0,    0,  8208,  0,  0,
    0,    0,    0,  0, 13528, 5320,    0,  0, 8208,     0,  0,  0,
    0,    0,    0,  0,     0,    0,    0,  0,    0,     0,  0,  0,
    0,    0,    0,  0,     0,    0,    0,  0,    0,     0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M6 <- drop0(matrix(c(
    0,     0,     0,  0,     0,     0,     0,  0,  0,  0,  0,  0,
    0,     0,  2160,  0, 15386, 17546,     0,  0,  0,  0,  0,  0,
    0,  2160,     0,  0,     0, 17010, 14850,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,     0,  0,  0,  0,  0,  0,
    0, 15386,     0,  0,     0, 15386,     0,  0,  0,  0,  0,  0,
    0, 17546, 17010,  0, 15386,     0, 14850,  0,  0,  0,  0,  0,
    0,     0, 14850,  0,     0, 14850,     0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,     0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,     0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,     0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,     0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,     0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M7 <- drop0(matrix(c(
    0,   240,    0,  0,   240,     0,  0,  0,  0,  0,  0,  0,
  240,     0, 1512,  0, 14338, 15610,  0,  0,  0,  0,  0,  0,
    0,  1512,    0,  0,     0,  1512,  0,  0,  0,  0,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
  240, 14338,    0,  0,     0, 14098,  0,  0,  0,  0,  0,  0,
    0, 15610, 1512,  0, 14098,     0,  0,  0,  0,  0,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,    0,  0,     0,     0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M8 <- drop0(matrix(c(
    0,  54,   6,   0,  236,   72,   0,   0,  72,  76,   0,  0,
   54,   0, 111,   0,  444,  459,   0,   0,  90,  95, 147,  0,
    6, 111,   0, 132,  135,  558, 484, 187,   0,   0, 189,  0,
    0,   0, 132,   0,    0,  180, 516, 204,   0,   0,   0,  0,
  236, 444, 135,   0,    0, 1173,   0,   0, 756, 779, 273,  0,
   72, 459, 558, 180, 1173,    0, 600, 255, 252, 266, 609,  0,
    0,   0, 484, 516,    0,  600,   0, 646,   0,   0,   0,  0,
    0,   0, 187, 204,    0,  255, 646,   0,   0,   0,   0,  0,
   72,  90,   0,   0,  756,  252,   0,   0,   0, 342,   0,  0,
   76,  95,   0,   0,  779,  266,   0,   0, 342,   0,   0,  0,
    0, 147, 189,   0,  273,  609,   0,   0,   0,   0,   0,  0,
    0,   0,   0,   0,    0,    0,   0,   0,   0,   0,   0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M9 <- drop0(matrix(c(
    0,   48,    0,   0,   86,   66,    0,    0,   0,    0,    0,    0,
   48,    0,  208,   0,  704, 1053,  105,    0, 108,  254,  168,    0,
    0,  208,    0,   0,  271, 1084,  916,  176,   0,  180,  452,  253,
    0,    0,    0,   0,    0,    0,  732,  192,   0,    0,  264,  276,
   86,  704,  271,   0,    0, 2351,  195,    0, 774, 1433,  294,    0,
   66, 1053, 1084,   0, 2351,    0, 2237,  240, 714, 2107, 2199,  345,
    0,  105,  916, 732,  195, 2237,    0, 1373,   0,    0, 1987, 1265,
    0,    0,  176, 192,    0,  240, 1373,    0,   0,    0,  374,  391,
    0,  108,    0,   0,  774,  714,    0,    0,   0,  912,    0,    0,
    0,  254,  180,   0, 1433, 2107,    0,    0, 912,    0,  420,    0,
    0,  168,  452, 264,  294, 2199, 1987,  374,   0,  420,    0,    0,
    0,    0,  253, 276,    0,  345, 1265,  391,   0,    0,    0,    0
  ), nrow = 12, byrow = TRUE))

  ans$M10 <- drop0(matrix(c(
    0,   8,   0,  0,   8,   0,   0,   0,   0,   0,   0,   0,
    8,   0, 140,  0, 233, 612, 153,   0,   0, 160,   0,   0,
    0, 140,   0,  0, 140, 696, 282,   0,   0, 200,   0,   0,
    0,   0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,
    8, 233, 140,  0,   0, 855, 210,   0, 456, 736,   0,   0,
    0, 612, 696,  0, 855,   0, 879,   0,   0, 940,   0,   0,
    0, 153, 282,  0, 210, 879,   0, 720,   0, 300, 858, 874,
    0,   0,   0,  0,   0,   0, 720,   0,   0,   0, 352, 368,
    0,   0,   0,  0, 456,   0,   0,   0,   0, 456,   0,   0,
    0, 160, 200,  0, 736, 940, 300,   0, 456,   0,   0,   0,
    0,   0,   0,  0,   0,   0, 858, 352,   0,   0,   0, 506,
    0,   0,   0,  0,   0,   0, 874, 368,   0,   0, 506,   0
  ), nrow = 12, byrow = TRUE))

  ans$M11 <- drop0(matrix(c(
    0,  292,    0,    0,   908,   840,     0,     0,    0,    0,    0,  0,
  292,    0, 1392,    0,  5288,  6498,     0,     0,  540,  570, 1176,  0,
    0, 1392,    0,    0,  2898,  6000,  2992,  2992,    0,    0, 1890,  0,
    0,    0,    0,    0,     0,     0,  3264,  3264,    0,    0,    0,  0,
  908, 5288, 2898,    0,     0, 18000,     0,     0, 3816, 4028, 3822,  0,
  840, 6498, 6000,    0, 18000,     0,  4080,  4080, 3276, 3458, 6888,  0,
    0,    0, 2992, 3264,     0,  4080,     0, 10336,    0,    0,    0,  0,
    0,    0, 2992, 3264,     0,  4080, 10336,     0,    0,    0,    0,  0,
    0,  540,    0,    0,  3816,  3276,     0,     0,    0,    0,    0,  0,
    0,  570,    0,    0,  4028,  3458,     0,     0,    0,    0,    0,  0,
    0, 1176, 1890,    0,  3822,  6888,     0,     0,    0,    0,    0,  0,
    0,    0,    0,    0,     0,     0,     0,     0,    0,    0,    0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M12 <- drop0(matrix(c(
    0,    0,    0,  0,     0,     0,     0,     0,  0,    0,    0,    0,
    0,    0, 1550,  0,  4212,  7722,   840,     0,  0, 1120,    0,    0,
    0, 1550,    0,  0,  3080,  8770,  2340,     0,  0, 1800,    0,    0,
    0,    0,    0,  0,     0,     0,     0,     0,  0,    0,    0,    0,
    0, 4212, 3080,  0,     0, 13662,  2730,     0,  0, 3640,    0,    0,
    0, 7722, 8770,  0, 13662,     0,  5910,     0,  0, 6560,    0,    0,
    0,  840, 2340,  0,  2730,  5910,     0, 12240,  0,    0, 5984, 6256,
    0,    0,    0,  0,     0,     0, 12240,     0,  0,    0, 5984, 6256,
    0,    0,    0,  0,     0,     0,     0,     0,  0,    0,    0,    0,
    0, 1120, 1800,  0,  3640,  6560,     0,     0,  0,    0,    0,    0,
    0,    0,    0,  0,     0,     0,  5984,  5984,  0,    0,    0,    0,
    0,    0,    0,  0,     0,     0,  6256,  6256,  0,    0,    0,    0
  ), nrow = 12, byrow = TRUE))

  ans$M13 <- drop0(matrix(c(
    0,     0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,  5040,  0, 17332, 22372,  0,  0,  0,  0,  0,  0,
    0,  5040,     0,  0, 16380, 21420,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0, 17332, 16380,  0,     0, 33712,  0,  0,  0,  0,  0,  0,
    0, 22372, 21420,  0, 33712,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$Mcoll <- drop0(matrix(c(
    0,   0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,  80,  0, 120, 105, 153,   0,   0, 160,   0,   0,
    0,  80,   0,  0, 140,   0, 150,   0,   0, 200,   0,   0,
    0,   0,   0,  0,   0,   0,   0,   0,   0,   0,   0,   0,
    0, 120, 140,  0,   0,  35, 210,   0, 456, 280,   0,   0,
    0, 105,   0,  0,  35,   0,  99,   0,   0,   0,   0,   0,
    0, 153, 150,  0, 210,  99,   0,   0,   0, 300,   0,   0,
    0,   0,   0,  0,   0,   0,   0,   0,   0,   0, 352, 368,
    0,   0,   0,  0, 456,   0,   0,   0,   0,   0,   0,   0,
    0, 160, 200,  0, 280,   0, 300,   0,   0,   0,   0,   0,
    0,   0,   0,  0,   0,   0,   0, 352,   0,   0,   0, 506,
    0,   0,   0,  0,   0,   0,   0, 368,   0,   0, 506,   0
  ), nrow = 12, byrow = TRUE))

  ans$Mexpa <- drop0(matrix(c(
    0,  20,   6,   0,  12,  72,  0,   0,  72,  76,   0,  0,
   20,   0,  63,   0,  91,  70,  0,   0,  90,  95, 147,  0,
    6,  63,   0, 132, 135, 189,  0, 187,   0,   0, 189,  0,
    0,   0, 132,   0,   0, 180,  0, 204,   0,   0,   0,  0,
   12,  91, 135,   0,   0,  48,  0,   0,   0,   0, 273,  0,
   72,  70, 189, 180,  48,   0,  0, 255, 252, 266,   0,  0,
    0,   0,   0,   0,   0,   0,  0,   0,   0,   0,   0,  0,
    0,   0, 187, 204,   0, 255,  0,   0,   0,   0,   0,  0,
   72,  90,   0,   0,   0, 252,  0,   0,   0, 342,   0,  0,
   76,  95,   0,   0,   0, 266,  0,   0, 342,   0,   0,  0,
    0, 147, 189,   0, 273,   0,  0,   0,   0,   0,   0,  0,
    0,   0,   0,   0,   0,   0,  0,   0,   0,   0,   0,  0
  ), nrow = 12, byrow = TRUE))

  # compare calculations with answers
  motifs <- get_motif_names()
  for (i in seq_len(length(motifs))) {

    mam_densematrix_densemethod <- build_motif_adjacency_matrix(
      adj_mat_dense, motifs[i], "func", "product", "dense")
    mam_sparsematrix_densemethod <- build_motif_adjacency_matrix(
      adj_mat_sparse, motifs[i], "func", "product", "dense")
    mam_densematrix_sparsemethod <- build_motif_adjacency_matrix(
      adj_mat_dense, motifs[i], "func", "product", "sparse")
    mam_sparsematrix_sparsemethod <- build_motif_adjacency_matrix(
      adj_mat_sparse, motifs[i], "func", "product", "sparse")

    expect_equal(mam_densematrix_densemethod, ans[[motifs[i]]])
    expect_equal(mam_sparsematrix_densemethod, ans[[motifs[i]]])
    expect_equal(mam_densematrix_sparsemethod, ans[[motifs[i]]])
    expect_equal(mam_sparsematrix_sparsemethod, ans[[motifs[i]]])

  }

})

test_that("build_motif_adjacency_matrix returns correct
           product-weighted structural matrix", {

  # test case
  adj_mat_dense <- demonstration_graph()$adj_mat_dense
  adj_mat_sparse <- demonstration_graph()$adj_mat_sparse

  # correct answers
  ans <- list()

  ans$Ms <- drop0(matrix(c(
    0,  2,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
    2,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  3,  0,  0,  0,  0, 11,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,
    4,  0,  0,  0,  0,  0,  0,  0, 18, 19,  0,  0,
    0,  0,  0,  0,  0,  0, 15,  0,  0, 20, 21,  0,
    0,  0, 11, 12,  0, 15,  0,  0,  0,  0, 22, 23,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0, 18,  0,  0,  0,  0, 24,  0,  0,
    0,  0,  0,  0, 19, 20,  0,  0, 24,  0,  0,  0,
    0,  0,  0,  0,  0, 21, 22,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0, 23,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$Md <- drop0(matrix(c(
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,  30,  56,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,  90,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0,
    0, 30,  0,  0,   0, 182,   0,   0,  0,  0,  0,  0,
    0, 56, 90,  0, 182,   0,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0, 272,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0, 272,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0,
    0,  0,  0,  0,   0,   0,   0,   0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M1 <- drop0(matrix(c(
    0,  0,  0,  0,  0,    0,    0,  0,  0,  0,    0,  0,
    0,  0,  0,  0,  0,    0,    0,  0,  0,  0,    0,  0,
    0,  0,  0,  0,  0,    0,    0,  0,  0,  0,    0,  0,
    0,  0,  0,  0,  0,    0,    0,  0,  0,  0,    0,  0,
    0,  0,  0,  0,  0,    0,    0,  0,  0,  0,    0,  0,
    0,  0,  0,  0,  0,    0, 6930,  0,  0,  0, 6930,  0,
    0,  0,  0,  0,  0, 6930,    0,  0,  0,  0, 6930,  0,
    0,  0,  0,  0,  0,    0,    0,  0,  0,  0,    0,  0,
    0,  0,  0,  0,  0,    0,    0,  0,  0,  0,    0,  0,
    0,  0,  0,  0,  0,    0,    0,  0,  0,  0,    0,  0,
    0,  0,  0,  0,  0, 6930, 6930,  0,  0,  0,    0,  0,
    0,  0,  0,  0,  0,    0,    0,  0,  0,  0,    0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M2 <- drop0(matrix(c(
    0,  0,  0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,  0,  0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,  0,  0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,  0,  0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,  0,  0,  0,     0, 69160,  0,  0,  0, 69160,  0,  0,
    0,  0,  0,  0, 69160,     0,  0,  0,  0, 69160,  0,  0,
    0,  0,  0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,  0,  0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,  0,  0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,  0,  0,  0, 69160, 69160,  0,  0,  0,     0,  0,  0,
    0,  0,  0,  0,     0,     0,  0,  0,  0,     0,  0,  0,
    0,  0,  0,  0,     0,     0,  0,  0,  0,     0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M3 <- drop0(matrix(c(
    0,     0,     0,  0,  0,     0,  0,  0,  0,  0,  0,  0,
    0,     0, 15120,  0,  0, 15120,  0,  0,  0,  0,  0,  0,
    0, 15120,     0,  0,  0, 15120,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,  0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,  0,     0,  0,  0,  0,  0,  0,  0,
    0, 15120, 15120,  0,  0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,  0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,  0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,  0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,  0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,  0,     0,  0,  0,  0,  0,  0,  0,
    0,     0,     0,  0,  0,     0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M4 <- drop0(matrix(c(
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0, 305760, 305760,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0, 305760,  0,  0,      0, 305760,  0,  0,  0,  0,  0,  0,
    0, 305760,  0,  0, 305760,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0,
    0,      0,  0,  0,      0,      0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M5 <- drop0(matrix(c(
    0,  0,  0,  0,    0,  0,  0,  0,    0,    0,  0,  0,
    0,  0,  0,  0,    0,  0,  0,  0,    0,    0,  0,  0,
    0,  0,  0,  0,    0,  0,  0,  0,    0,    0,  0,  0,
    0,  0,  0,  0,    0,  0,  0,  0,    0,    0,  0,  0,
    0,  0,  0,  0,    0,  0,  0,  0, 8208, 8208,  0,  0,
    0,  0,  0,  0,    0,  0,  0,  0,    0,    0,  0,  0,
    0,  0,  0,  0,    0,  0,  0,  0,    0,    0,  0,  0,
    0,  0,  0,  0,    0,  0,  0,  0,    0,    0,  0,  0,
    0,  0,  0,  0, 8208,  0,  0,  0,    0, 8208,  0,  0,
    0,  0,  0,  0, 8208,  0,  0,  0, 8208,    0,  0,  0,
    0,  0,  0,  0,    0,  0,  0,  0,    0,    0,  0,  0,
    0,  0,  0,  0,    0,  0,  0,  0,    0,    0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M6 <- drop0(matrix(c(
    0,  0,     0,  0,  0,     0,     0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,  0,     0,     0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,  0, 14850, 14850,  0,  0,  0,  0,  0,
    0,  0,     0,  0,  0,     0,     0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,  0,     0,     0,  0,  0,  0,  0,  0,
    0,  0, 14850,  0,  0,     0, 14850,  0,  0,  0,  0,  0,
    0,  0, 14850,  0,  0, 14850,     0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,  0,     0,     0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,  0,     0,     0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,  0,     0,     0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,  0,     0,     0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,  0,     0,     0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M7 <- drop0(matrix(c(
    0, 240,  0,  0, 240,  0,  0,  0,  0,  0,  0,  0,
  240,   0,  0,  0, 240,  0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
  240, 240,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M8 <- drop0(matrix(c(
    0,  6,   6,   0, 148,   0,   0,  0, 72, 76,  0,  0,
    6,  0,   6,   0,   0,   0,   0,  0,  0,  0,  0,  0,
    6,  6,   0, 132,   0,   0, 132,  0,  0,  0,  0,  0,
    0,  0, 132,   0,   0, 180, 312,  0,  0,  0,  0,  0,
  148,  0,   0,   0,   0,   0,   0,  0, 72, 76,  0,  0,
    0,  0,   0, 180,   0,   0, 180,  0,  0,  0,  0,  0,
    0,  0, 132, 312,   0, 180,   0,  0,  0,  0,  0,  0,
    0,  0,   0,   0,   0,   0,   0,  0,  0,  0,  0,  0,
   72,  0,   0,   0,  72,   0,   0,  0,  0,  0,  0,  0,
   76,  0,   0,   0,  76,   0,   0,  0,  0,  0,  0,  0,
    0,  0,   0,   0,   0,   0,   0,  0,  0,  0,  0,  0,
    0,  0,   0,   0,   0,   0,   0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M9 <- drop0(matrix(c(
    0,  0,   0,   0,  0,   0,   0,  0,   0,   0,   0,   0,
    0,  0,   0,   0,  0,   0,   0,  0,   0,   0,   0,   0,
    0,  0,   0,   0,  0,   0, 495,  0,   0,   0, 242, 253,
    0,  0,   0,   0,  0,   0, 540,  0,   0,   0, 264, 276,
    0,  0,   0,   0,  0,   0,   0,  0,   0,   0,   0,   0,
    0,  0,   0,   0,  0,   0, 345,  0, 480, 900, 420, 345,
    0,  0, 495, 540,  0, 345,   0,  0,   0,   0, 506, 874,
    0,  0,   0,   0,  0,   0,   0,  0,   0,   0,   0,   0,
    0,  0,   0,   0,  0, 480,   0,  0,   0, 480,   0,   0,
    0,  0,   0,   0,  0, 900,   0,  0, 480,   0, 420,   0,
    0,  0, 242, 264,  0, 420, 506,  0,   0, 420,   0,   0,
    0,  0, 253, 276,  0, 345, 874,  0,   0,   0,   0,   0
  ), nrow = 12, byrow = TRUE))

  ans$M10 <- drop0(matrix(c(
    0,  0,  0,  0,  0,   0,   0,  0,  0,   0,   0,   0,
    0,  0, 33,  0,  0,   0,  33,  0,  0,   0,   0,   0,
    0, 33,  0,  0,  0,   0,  33,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,   0,   0,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,   0,   0,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,   0, 300,  0,  0, 300,   0,   0,
    0, 33, 33,  0,  0, 300,   0,  0,  0, 300, 506, 506,
    0,  0,  0,  0,  0,   0,   0,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,   0,   0,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0, 300, 300,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,   0, 506,  0,  0,   0,   0, 506,
    0,  0,  0,  0,  0,   0, 506,  0,  0,   0, 506,   0
  ), nrow = 12, byrow = TRUE))

  ans$M11 <- drop0(matrix(c(
    0,  112,    0,    0,  728,  840,     0,     0,    0,   0,    0,  0,
  112,    0,   90,    0, 1200, 1288,     0,     0,  540, 570, 1176,  0,
    0,   90,    0,    0,   90, 1890,  2992,  2992,    0,   0, 1890,  0,
    0,    0,    0,    0,    0,    0,  3264,  3264,    0,   0,    0,  0,
  728, 1200,   90,    0,    0, 7826,     0,     0, 3816, 570, 3822,  0,
  840, 1288, 1890,    0, 7826,    0,  4080,  4080, 3276,   0, 6888,  0,
    0,    0, 2992, 3264,    0, 4080,     0, 10336,    0,   0,    0,  0,
    0,    0, 2992, 3264,    0, 4080, 10336,     0,    0,   0,    0,  0,
    0,  540,    0,    0, 3816, 3276,     0,     0,    0,   0,    0,  0,
    0,  570,    0,    0,  570,    0,     0,     0,    0,   0,    0,  0,
    0, 1176, 1890,    0, 3822, 6888,     0,     0,    0,   0,    0,  0,
    0,    0,    0,    0,    0,    0,     0,     0,    0,   0,    0,  0
  ), nrow = 12, byrow = TRUE))

  ans$M12 <- drop0(matrix(c(
    0,    0,    0,  0,    0,    0,     0,     0,  0,    0,    0,    0,
    0,    0,    0,  0,    0, 1960,   840,     0,  0, 1120,    0,    0,
    0,    0,    0,  0,    0, 1800,     0,     0,  0, 1800,    0,    0,
    0,    0,    0,  0,    0,    0,     0,     0,  0,    0,    0,    0,
    0,    0,    0,  0,    0, 2730,  2730,     0,  0,    0,    0,    0,
    0, 1960, 1800,  0, 2730,    0,  3570,     0,  0, 2920,    0,    0,
    0,  840,    0,  0, 2730, 3570,     0, 12240,  0,    0, 5984, 6256,
    0,    0,    0,  0,    0,    0, 12240,     0,  0,    0, 5984, 6256,
    0,    0,    0,  0,    0,    0,     0,     0,  0,    0,    0,    0,
    0, 1120, 1800,  0,    0, 2920,     0,     0,  0,    0,    0,    0,
    0,    0,    0,  0,    0,    0,  5984,  5984,  0,    0,    0,    0,
    0,    0,    0,  0,    0,    0,  6256,  6256,  0,    0,    0,    0
  ), nrow = 12, byrow = TRUE))

  ans$M13 <- drop0(matrix(c(
    0,  0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,  0,     0,  0, 16380, 16380,  0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,  0, 16380,  0,     0, 16380,  0,  0,  0,  0,  0,  0,
    0,  0, 16380,  0, 16380,     0,  0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0,
    0,  0,     0,  0,     0,     0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  ans$Mcoll <- drop0(matrix(c(
    0,  0,  0,  0,  0,  0,   0,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,  0,  33,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,  0,   0,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,  0,   0,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,  0,   0,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,  0,   0,  0,  0,   0,   0,   0,
    0, 33,  0,  0,  0,  0,   0,  0,  0, 300,   0,   0,
    0,  0,  0,  0,  0,  0,   0,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,  0,   0,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,  0, 300,  0,  0,   0,   0,   0,
    0,  0,  0,  0,  0,  0,   0,  0,  0,   0,   0, 506,
    0,  0,  0,  0,  0,  0,   0,  0,  0,   0, 506,   0
  ), nrow = 12, byrow = TRUE))

  ans$Mexpa <- drop0(matrix(c(
    0,  0,   6,   0,  0,   0,  0,  0, 72, 76,  0,  0,
    0,  0,   0,   0,  0,   0,  0,  0,  0,  0,  0,  0,
    6,  0,   0, 132,  0,   0,  0,  0,  0,  0,  0,  0,
    0,  0, 132,   0,  0, 180,  0,  0,  0,  0,  0,  0,
    0,  0,   0,   0,  0,   0,  0,  0,  0,  0,  0,  0,
    0,  0,   0, 180,  0,   0,  0,  0,  0,  0,  0,  0,
    0,  0,   0,   0,  0,   0,  0,  0,  0,  0,  0,  0,
    0,  0,   0,   0,  0,   0,  0,  0,  0,  0,  0,  0,
   72,  0,   0,   0,  0,   0,  0,  0,  0,  0,  0,  0,
   76,  0,   0,   0,  0,   0,  0,  0,  0,  0,  0,  0,
    0,  0,   0,   0,  0,   0,  0,  0,  0,  0,  0,  0,
    0,  0,   0,   0,  0,   0,  0,  0,  0,  0,  0,  0
  ), nrow = 12, byrow = TRUE))

  # compare calculations with answers
  motifs <- get_motif_names()
  for (i in seq_len(length(motifs))) {

    mam_densematrix_densemethod <- build_motif_adjacency_matrix(
      adj_mat_dense, motifs[i], "struc", "product", "dense")
    mam_sparsematrix_densemethod <- build_motif_adjacency_matrix(
      adj_mat_sparse, motifs[i], "struc", "product", "dense")
    mam_densematrix_sparsemethod <- build_motif_adjacency_matrix(
      adj_mat_dense, motifs[i], "struc", "product", "sparse")
    mam_sparsematrix_sparsemethod <- build_motif_adjacency_matrix(
      adj_mat_sparse, motifs[i], "struc", "product", "sparse")

    expect_equal(mam_densematrix_densemethod, ans[[motifs[i]]])
    expect_equal(mam_sparsematrix_densemethod, ans[[motifs[i]]])
    expect_equal(mam_densematrix_sparsemethod, ans[[motifs[i]]])
    expect_equal(mam_sparsematrix_sparsemethod, ans[[motifs[i]]])

  }

})
