% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{kmeanspp}
\alias{kmeanspp}
\title{kmeans++ clustering}
\usage{
kmeanspp(data, k = 2, iter.max = 100, nstart = 10, ...)
}
\arguments{
\item{data}{An \eqn{N \times d} matrix, where there are \eqn{N} samples
in dimension \eqn{d}.}

\item{k}{The number of clusters.}

\item{iter.max}{The maximum number of iterations.}

\item{nstart}{The number of restarts.}

\item{...}{Additional arguments passed to \code{\link[stats]{kmeans}}.}
}
\value{
A list with 9 entries:
\itemize{
  \item \code{cluster}: A vector of integers from 1:k indicating the
    cluster to which each point is allocated.
  \item \code{centers}: A matrix of cluster centers.
  \item \code{totss}: The total sum of squares.
  \item \code{withinss}: Vector of within-cluster sum of squares,
    one component per cluster.
  \item \code{tot.withinss}: Total within-cluster sum of squares,
    i.e.sum(withinss).
  \item \code{betweenss}: The between-cluster sum of squares,
    i.e.totss-tot.withinss.
  \item \code{size}: The number of points in each cluster.
  \item \code{iter}: The number of (outer) iterations.
  \item \code{ifault}: An integer indicator of a possible algorithm problem.
  \item \code{initial.centers}: The initial centers used.
}
}
\description{
Use the kmeans++ algorithm to cluster points
into \code{k} clusters, as implemented in the
deprecated LICORS package, using the
built-in function \link[stats]{kmeans}.
}
\examples{
set.seed(1984)
n <- 100
X = matrix(rnorm(n), ncol = 2)
Y = matrix(runif(length(X)*2, -1, 1), ncol = ncol(X))
Z = rbind(X, Y)
cluster_Z = kmeanspp(Z, k = 5)
}
\references{
Arthur, D. and S. Vassilvitskii (2007).
``k-means++: The advantages of careful seeding.''
In H. Gabow (Ed.), Proceedings of the 18th Annual ACM-SIAM
Symposium on Discrete Algorithms
[SODA07], Philadelphia, pp. 1027-1035.
Society for Industrial and Applied Mathematics.
}
\seealso{
\code{\link[stats]{kmeans}}
}
