% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.rateMatrix.R
\name{as.rateMatrix}
\alias{as.rateMatrix}
\title{Conversion among data and phylogeny objects}
\usage{
as.rateMatrix(phy, x, data)
}
\arguments{
\item{phy}{An object of class "phylo" (see ape package).}

\item{x}{The explanatory (discrete) variable used to define the hypothesised rate categories. Can be specified as a column number or column name}

\item{data}{The explanatory (discrete) variable used to define the hypothesised rate categories. Can be specified as a column number or column name}
}
\value{
rateMatrix An object of class "rateMatrix" - a list of matrices describing the expected variances and covariances of between species. Each matrix refers to the variances and covariances for a given state of x (see Thomas et al. 2006).
}
\description{
Function to generate a "rateMatrix" object containing a set of variance covariance matrices. 
Note that \code{as.rateMatrix} calls the CAIC function \code{vcv.array} multiple times and this can be slow for large phylogenies (though faster than using the "ape" equivalent \code{vcv.phylo}).
}
\examples{
## Read in phylogeny and data from Thomas et al. (2009)
data(anolis.tree)
data(anolis.data)

## Convert data to class rateMatrix
anolis.rateMatrix <- as.rateMatrix(phy=anolis.tree, x="geo_ecomorph", data=anolis.data)
}
\references{
Thomas GH, Freckleton RP, & Szekely T. 2006. Comparative analyses of the influence of developmental mode on phenotypic diversification rates in shorebirds. Proceedings of the Royal Society B 273, 1619-1624.
}
\author{
Gavin Thomas
}
