% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodeTimes.R
\name{nodeTimes}
\alias{nodeTimes}
\title{Get times for nodes and tips}
\usage{
nodeTimes(phy)
}
\arguments{
\item{phy}{An object of class "phylo" (see ape package).}
}
\value{
Returns a matrix corresponging the phy "edge" matrix showning internal and external node times
}
\description{
Produces branching and tip times for ultrametric and non-ultrametric trees
}
\note{
\code{nodeTimes} is essentially a re-written version of the "ape" \code{branching.times}.
}
\examples{
## Read in phylogeny from Thomas et al. (2009)
data(anolis.tree)
anolis.node.times <- nodeTimes(phy=anolis.tree)
}
\author{
Mark Puttick, Emmanuel Paradis
}
