% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformPhylo.R
\name{transformPhylo}
\alias{transformPhylo}
\title{Phylogenetic tree transformations}
\usage{
transformPhylo(phy, model = NULL, y = NULL, meserr = NULL,
  sigmaScale = NULL, kappa = NULL, lambda = NULL, delta = NULL,
  alpha = NULL, psi = NULL, lambda.sp = NULL, nodeIDs = NULL,
  rateType = NULL, branchRates = NULL, cladeRates = NULL,
  splitTime = NULL, timeRates = NULL, acdcRate = NULL,
  branchLabels = NULL)
}
\arguments{
\item{phy}{An object of class "phylo" (see ape package).}

\item{model}{The model of trait evolution (see details).}

\item{y}{A matrix of trait values.}

\item{meserr}{A vector (or matrix) of measurement error for each tip. This is only applicable to univariate analyses. Largely untested - please use cautiously}

\item{sigmaScale}{If meserr is included, a scaling factor for the amount of error that is added}

\item{kappa}{Value of kappa transform.}

\item{lambda}{Value of lambda transform.}

\item{delta}{Value of delta transform.}

\item{alpha}{Value of alpha (OU) transform.}

\item{psi}{Value of psi transform.}

\item{lambda.sp}{Estimate of speciation (lambda) for the psi models}

\item{nodeIDs}{Integer - ancestral nodes of clades.}

\item{rateType}{If model="clade", a vector specifying if rate shift occurs in a clade ("clade") or on the single branch leading to a clade ("branch").}

\item{branchRates}{Numeric vector specifying relative rates for individual branches}

\item{cladeRates}{Numeric vector specifying telative rates for clades.}

\item{splitTime}{A split time (measured from the present, or most recent species) at which a shift in the rate occurs for the "timeSlice" model}

\item{timeRates}{The rates (from ancient to recent) for the timeSlice model}

\item{acdcRate}{Value of ACDC transform.}

\item{branchLabels}{A vector of length equal to the number of internal branches, signifying the which "multiPsi" class it belongs to}
}
\value{
phy  A phylo object
}
\description{
Transforms the branch lengths of a phylo object according to a model of trait evolution (see details).
}
\details{
Transforms the branch lengths of a phylo object according to one of the following models:
\itemize{
 \item {model="bm"}- Brownian motion (constant rates random walk)
 \item {model="kappa"} - fits Pagel's kappa by raising all branch lengths to the power kappa. As kappa approaches zero, trait change becomes focused at branching events. For complete phylogenies, if kappa approaches zero this infers speciational trait change. 
 \item {model="lambda"} - fits Pagel's lambda to estimate phylogenetic signal by multiplying all internal branches of the tree by lambda, leaving tip branches as their original length (root to tip distances are unchanged);
 \item {model="delta"} - fits Pagel's delta by raising all node depths to the power delta. If delta <1, trait evolution is concentrated early in the tree whereas if delta >1 trait evolution is concentrated towards the tips. Values of delta above one can be difficult to fit reliably.
 \item {model="free"} - fits Mooer's et al's (1999) free model where each branch has its own rate of trait evolution. This can be a useful exploratory analysis but it is slow due to the number of parameters, particularly for large trees.
 \item {model="clade"} - fits a model where particular clades are a priori hypothesised to have different rates of trait evolution (see O'Meara et al. 2006; Thomas et al. 2006, 2009). Clades are specified using nodeIDs and are defined as the mrca node. Unique rates for each clade are specified using cladeRates. rateType specifies whether the rate shift occurs in the stem clade or on the single branch leading to the clade.
 \item {model="OU"} - fits an Ornstein-Uhlenbeck model - a random walk with a central tendency proportional to alpha. High values of alpha can be interpreted as evidence of evolutionary constraints, stabilising selection or weak phylogenetic signal.
 \item {model="psi"} - fits a model to assess to the relative contributions of speciation and gradual evolution to a trait's evolutionary rate (Ingram 2010). Note that 'original nodes' from the full phylogeny can be included as an element on the phylogeny (e.g., phy$orig.node) as well as estimates of 'hidden' speciation (e.g., phy$hidden.speciation) if estimates of extinction (mu) are > 0.
\item {model="multiPsi"} {fits a acceleration-deacceleration model to assess to the relative contributions of speciation and gradual evolution to a trait's evolutionary rate but allows seperate values of psi fitted to seperate branches (Ingram 2010; Ingram et al. 2016). Note that 'original nodes' from the full phylogeny can be included as an element on the phylogeny (e.g., phy$orig.node) as well as estimates of 'hidden' speciation (e.g., phy$hidden.speciation) if estimates of extinction (mu) are > 0.}
\item {model="ACDC"} {fits a model to in which rates can exponentially increased or decrease through time (Blomberg et al. 2003). If the upper bound is < 0, the model is equivalent to the 'Early Burst' model of Harmon et al. 2010. If a nodeIDs is supplied, the model will fit a ACDC model nested within a clade, with a BM fit to the rest of the tree.}
\item {model="timeSlice"} {A model in which all branch rates change at time(s) in the past.}
 }
}
\examples{
data(anolis.tree)
anolis.treeDelta <- transformPhylo(phy=anolis.tree, model="delta", delta=0.5)
}
\references{
Ingram T. 2011. Speciation along a depth gradient in a marine adaptive radiation. Proc. Roy. Soc. B. 278, 613-618.

Ingram T,  Harrison AD, Mahler L, Castaneda MdR, Glor RE, Herrel A, Stuart YE, and Losos JB. Comparative tests of the role of dewlap size in Anolis lizard speciation. Proc. Roy. Soc. B. 283, 20162199. #' @references Mooers AO, Vamosi S, & Schluter D. 1999. Using phylogenies to test macroevolutionary models of trait evolution: sexual selection and speciation in Cranes (Gruinae). American Naturalist 154, 249-259.

O'Meara BC, Ane C, Sanderson MJ & Wainwright PC. 2006. Testing for different rates of continuous trait evolution using likelihood. Evolution 60, 922-933

Pagel M. 1997. Inferring evolutionary processes from phylogenies. Zoologica Scripta 26, 331-348.

Pagel M. 1999 Inferring the historical patterns of biological evolution. Nature 401, 877-884.

Thomas GH, Meiri S, & Phillimore AB. 2009. Body size diversification in Anolis: novel environments and island effects. Evolution 63, 2017-2030.
}
\author{
Gavin Thomas, Mark Puttick
}
