% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformPhylo.sim.R
\name{transformPhylo.sim}
\alias{transformPhylo.sim}
\title{Phylogenetic tree transformations}
\usage{
transformPhylo.sim(phy, n = 1, x = NULL, model = NULL, kappa = NULL,
  lambda = NULL, delta = NULL, alpha = NULL, psi = NULL,
  acdcRate = NULL, lambda.sp = NULL, nodeIDs = NULL, rateType = NULL,
  cladeRates = NULL, branchRates = NULL, rate = NULL,
  group.means = NULL, splitTime = NULL, timeRates = NULL,
  branchLabels = NULL)
}
\arguments{
\item{phy}{An object of class "phylo" (see ape package).}

\item{n}{Number of simulations}

\item{x}{Vector, matrix or data.frame (with taxon names as names or rownames) of categories for each species. Only applicable if model="mixedRate"}

\item{model}{The model of trait evolution (see details).}

\item{kappa}{Value of kappa transform.}

\item{lambda}{Value of lambda transform.}

\item{delta}{Value of delta transform.}

\item{alpha}{Value of alpha (OU) transform.}

\item{psi}{Value of psi transform.  Note that 'original nodes' from the full phylogeny can be included as an element on the phylogeny (e.g., phy$orig.node) as well as estimates of 'hidden' speciation (e.g., phy$hidden.speciation) if estimates of extinction (mu) are > 0.}

\item{acdcRate}{Value of ACDC transform.}

\item{lambda.sp}{Estimate of speciation (lambda) for the psi models}

\item{nodeIDs}{Integer - ancestral nodes of clades.}

\item{rateType}{If model="clade", a vector specifying if rate shift occurs in a clade ("clade") or on the single branch leading to a clade ("branch").}

\item{cladeRates}{Numeric vector specifying telative rates for clades.}

\item{branchRates}{Numeric vector specifying relative rates for individual branches}

\item{rate}{a vector of relative rate parameters. The length of the vector is equal to the number of rates being estimated.}

\item{group.means}{a vector of the relative difference in means between rate categories, expressed as a scalar applied to the expected standard deviation (see Ricklefs 2006)}

\item{splitTime}{A split time (measured from the present, or most recent species) at which a shift in the rate occurs for the "timeSlice" model}

\item{timeRates}{The rates (from ancient to recent) for the timeSlice model}

\item{branchLabels}{Branches on which different psi parameters are estimated in the "multipsi" model.}
}
\value{
Returns a matrix of simulated dated with taxon names as rownames (number of columns=n).
}
\description{
Transforms the branch lengths of a phylo object according to a model of trait evolution (see details).
}
\examples{
data(anolis.tree)
data(anolis.data)

# Simulate 10 sets of data with kappa=0.1 using the anolis tree
sim.dat1 <- transformPhylo.sim(phy=anolis.tree, n=10, model="kappa", kappa=0.1)

# Simulate 10 sets of data where rates and means differ between to the categories defined by "x"
x <- anolis.data$geo_ecomorph
names(x) <-  rownames(anolis.data)
sim.dat2 <- transformPhylo.sim(phy=anolis.tree, n=10, x=x, model="mixedRate", rate=c(1,1,2,4),
group.means=c(0,5,0,0))
}
\references{
Ricklefs RE. 2006. Time, species, and the generation of trait variation in clades. Systematic Biology 55, 151-159.

Ricklefs RE. 2006. Thomas GH, Meiri S, & Phillimore AB. 2009. Body size diversification in Anolis: novel environments and island effects. Evolution 63, 2017-2030
}
\author{
Gavin Thomas, Mark Puttick
}
