% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_entropy.R
\name{mt_sample_entropy}
\alias{mt_sample_entropy}
\title{Calculate sample entropy.}
\usage{
mt_sample_entropy(data, use = "tn_trajectories", save_as = "measures",
  method = "pracma", dimension = "xpos", lag = 3, r = NULL,
  show_progress = TRUE)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import 
functions (see \link{mt_example} for details).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{save_as}{a character string specifying where the calculated measures
should be stored.}

\item{method}{a character string specifying the method used for calculating
sample entropy (see Details).}

\item{dimension}{a character string specifying the dimension based on which
sample entropy should be calculated. By default (xpos), the x-positions are
used.}

\item{lag}{an integer passed on to the sample entropy function (see Details).}

\item{r}{a numeric value passed on to the sample entropy function (see
Details).}

\item{show_progress}{logical indicating whether function should report on the
progress.}
}
\value{
A mousetrap data object (see \link{mt_example}).
  
  If a data.frame with label specified in \code{save_as} (by default
  "measures") already exists, the sample entropy values are added as
  additional column(s) (by merging them using the \link{mt_id} variable).
  
  If not, an additional \link{data.frame} will be added.
}
\description{
Calculate sample entropy for each trajectory.
}
\details{
\code{mt_sample_entropy} calculates the sample entropy for each trajectory as
a measure of its complexity. Hehman et al (2015) provide details on how 
sample entropy can be calculated and applied in mouse-tracking (following 
Dale et al., 2007). They apply the sample entropy measure to the x-positions 
(which is also the default here, as in a standard mouse-tracking task with 
buttons located in the top-left and right corners mostly the movements in the
horizontal direction are of interest). Besides, they recommend using the 
time-normalized trajectories so all trajectories have the same length.

Sample entropy is computed by comparing windows of a fixed size (specified 
using \code{lag}) across all recorded positions. Sample entropy is the 
negative natural logarithm of the conditional probability that this windows 
remains similar across the trial (Hehman et al., 2015). A window is 
considered to be similar to another if their distance is smaller than a 
specified tolerance value (which can be specified using \code{r}). Hehman et 
al. (2015) use a tolerance value of 0.2 * standard deviation of all 
differences between adjacent x-positions in the dataset (which is the default
implemented here).

The specific formula for sample entropy depends on the function specified in 
\code{method}. Per default ("pracma"), the \link[pracma]{sample_entropy} 
function from the pracma package is used. Alternatively ("hehman") the 
function by Hehman et al. (2015) is used. Finally, it is also possible to 
calculate sample_entropy values using both functions ("both").
}
\examples{
# Calculate sample entropy based on time-normalized
# trajectories and merge results with other meausres
# derived from raw trajectories
mt_example <- mt_calculate_measures(mt_example)
mt_example <- mt_time_normalize(mt_example,
  save_as="tn_trajectories", nsteps=101)
mt_example <- mt_sample_entropy(mt_example,
  use="tn_trajectories", save_as="measures",
  method="pracma", dimension="xpos", lag=3)

}
\references{
Dale, R., Kehoe, C., & Spivey, M. J. (2007). Graded motor
  responses in the time course of categorizing atypical exemplars.
  \emph{Memory & Cognition, 35}(1), 15-28.

Hehman, E., Stolier, R. M., & Freeman, J. B. (2015). Advanced mouse-tracking
analytic techniques for enhancing psychological science. \emph{Group
Processes & Intergroup Relations, 18}(3), 384-401.
}
\seealso{
\link{mt_calculate_measures} for calculating other mouse-tracking
measures.
}

