% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{simData}
\alias{simData}
\title{Simulation tool}
\usage{
simData(nbAnimals = 1, nbStates = 2, stepDist = c("gamma", "weibull",
  "lnorm", "exp"), angleDist = c("vm", "wrpcauchy", "none"), stepPar = NULL,
  anglePar = NULL, beta = NULL, covs = NULL, nbCovs = 0,
  zeroInflation = FALSE, obsPerAnimal = c(500, 1500), model = NULL,
  states = FALSE)
}
\arguments{
\item{nbAnimals}{Number of observed individuals to simulate.}

\item{nbStates}{Number of behavioural states to simulate.}

\item{stepDist}{Name of the distribution of the step lengths (as a character string).
Supported distributions are: gamma, weibull, lnorm, exp. Default: gamma.}

\item{angleDist}{Name of the distribution of the turning angles (as a character string).
Supported distributions are: vm, wrpcauchy. Set to \code{"none"} if the angle distribution should
not be estimated. Default: vm.}

\item{stepPar}{Parameters of the step length distribution.}

\item{anglePar}{Parameters of the turning angle distribution.}

\item{beta}{Matrix of regression parameters for the transition probabilities (more information
in "Details").}

\item{covs}{Covariate values to include in the model, as a dataframe. Default: \code{NULL}.
Covariates can also be simulated according to a standard normal distribution, by setting
\code{covs} to \code{NULL}, and specifying \code{nbCovs>0}.}

\item{nbCovs}{Number of covariates to simulate (0 by default). Does not need to be specified of
\code{covs} is specified.}

\item{zeroInflation}{\code{TRUE} if the step length distribution is inflated in zero.
Default: \code{FALSE}. If \code{TRUE}, values for the zero-mass parameters should be
included in \code{stepPar}.}

\item{obsPerAnimal}{Either the number of the number of observations per animal (if single value),
or the bounds of the number of observations per animal (if vector of two values). In the latter case,
the numbers of obervations generated for each animal are uniformously picked from this interval.
Default: \code{c(500,1500)}.}

\item{model}{A moveHMM object. This option can be used to simulate from a fitted model.  Default: NULL.
Note that, if this argument is specified, most other arguments will be ignored -- except for nbAnimals,
obsPerAnimal, covs (if covariate values different from those in the data should be specified),
and states.}

\item{states}{\code{TRUE} if the simulated states should be returned, \code{FALSE} otherwise (default).}
}
\value{
An object moveData, i.e. a dataframe of:
\item{ID}{The ID(s) of the observed animal(s)}
\item{step}{The step lengths}
\item{angle}{The turning angles (if any)}
\item{x}{Either easting or longitude}
\item{y}{Either norting or latitude}
\item{...}{Covariates (if any)}
}
\description{
Simulates movement data from an HMM.
}
\details{
\itemize{
\item The matrix \code{beta} of regression coefficients for the transition probabilities has
one row for the intercept, plus one row for each covariate, and one column for
each non-diagonal element of the transition probability matrix. For example, in a 3-state
HMM with 2 covariates, the matrix \code{beta} has three rows (intercept + two covariates)
and six columns (six non-diagonal elements in the 3x3 transition probability matrix - filled in
row-wise).
In a covariate-free model (default), \code{beta} has one row, for the intercept.

\item If the length of covariate values passed (either through 'covs', or 'model') is not the same
as the number of observations suggested by 'nbAnimals' and 'obsPerAnimal', then the series of
covariates is either shortened (removing last values - if too long) or extended (starting
over from the first values - if too short).
}
}
\examples{
# 1. Pass a fitted model to simulate from
# (m is a moveHMM object - as returned by fitHMM - automatically loaded with the package)
# We keep the default nbAnimals=1.
m <- example$m
obsPerAnimal=c(50,100)
data <- simData(model=m,obsPerAnimal=obsPerAnimal)

# 2. Pass the parameters of the model to simulate from
stepPar <- c(1,10,1,5,0.2,0.3) # mean1, mean2, sd1, sd2, z1, z2
anglePar <- c(pi,0,0.5,2) # mean1, mean2, k1, k2
stepDist <- "gamma"
angleDist <- "vm"
data <- simData(nbAnimals=5,nbStates=2,stepDist=stepDist,angleDist=angleDist,stepPar=stepPar,
               anglePar=anglePar,nbCovs=2,zeroInflation=TRUE,obsPerAnimal=obsPerAnimal)

stepPar <- c(1,10,1,5) # mean1, mean2, sd1, sd2
anglePar <- c(pi,0,0.5,0.7) # mean1, mean2, k1, k2
stepDist <- "weibull"
angleDist <- "wrpcauchy"
data <- simData(nbAnimals=5,nbStates=2,stepDist=stepDist,angleDist=angleDist,stepPar=stepPar,
               anglePar=anglePar,obsPerAnimal=obsPerAnimal)

# step length only and zero-inflation
stepPar <- c(1,10,1,5,0.2,0.3) # mean1, mean2, sd1, sd2, z1, z2
stepDist <- "gamma"
data <- simData(nbAnimals=5,nbStates=2,stepDist=stepDist,angleDist="none",stepPar=stepPar,
               nbCovs=2,zeroInflation=TRUE,obsPerAnimal=obsPerAnimal)

# include covariates
# (note that it is useless to specify "nbCovs", which is determined
# by the number of columns of "cov")
cov <- data.frame(temp=rnorm(500,20,5))
stepPar <- c(1,10,1,5) # mean1, mean2, sd1, sd2
anglePar <- c(pi,0,0.5,2) # mean1, mean2, k1, k2
stepDist <- "gamma"
angleDist <- "vm"
data <- simData(nbAnimals=5,nbStates=2,stepDist=stepDist,angleDist=angleDist,stepPar=stepPar,
                anglePar=anglePar,covs=cov)

}

