% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlotData.R
\name{getPlotData}
\alias{getPlotData}
\title{Data to produce plots of fitted model}
\usage{
getPlotData(m, type, format = "wide", alpha = 0.95)
}
\arguments{
\item{m}{Fitted HMM object, as output by fitHMM.}

\item{type}{Type of plot, one of: "dist", "tpm", "stat"}

\item{format}{Format of data, either "wide" (for base graphics)
or "long" (for ggplot)}

\item{alpha}{Level of confidence intervals. Default: 0.95, i.e.,
95\% confidence intervals}
}
\value{
Data frame (or list of data frames) containing data in a format
that can easily be plotted. If type = "dist", the output is a list with
two elements, "step" and "angle". If type = "tpm" or "stat", the output
is a list with one element for each covariate. See details for more
extensive description of output.
}
\description{
Data to produce plots of fitted model
}
\details{
\itemize{
\item{If type = "dist", the function evaluates each state-dependent
distribution over the range of observed variable (step length or
turning angle), and weighs them by the proportion of time spent
in each state (obtained from Viterbi state sequence).}
\item{If type = "tpm", the function returns transition probabilities
estimated over a range of covariate values. Other covariates are
fixed to their mean values.}
}
}
