% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_frames.R
\name{animate_frames}
\alias{animate_frames}
\title{Animate frames}
\usage{
animate_frames(frames, out_file, fps = 25, width = 700, height = 700,
  res = 100, end_pause = 0, display = TRUE, overwrite = FALSE,
  verbose = TRUE, ...)
}
\arguments{
\item{frames}{list of \code{ggplot2} objects, crated with \code{\link{frames_spatial}}.}

\item{out_file}{character, the output file path, e.g. "/dir/to/file.mov". The file extension must correspond to a file format known by the available renderers of the running system. Use \code{\link{suggest_formats}} to get a vector of suggested known file formats.}

\item{fps}{numeric, the number of frames to be displayed per second. Default is 2.}

\item{width}{numeric, width of the output animation in pixels.}

\item{height}{numeric, height of the output animation in pixels.}

\item{res}{numeric, resolution of the output animation in ppi.}

\item{end_pause}{numeric, defining how many seconds the last frame of the animation should be hold to add a pause at the the end of the animation. Default is 0 seconds to not add a pause.}

\item{display}{logical, whether the animation should be displayed after rendering or not.}

\item{overwrite}{logical, wether to overwrite an existing file, if \code{out_file} is already present.}

\item{verbose}{logical, if \code{TRUE}, messages on the function's progress are displayed (default).}

\item{...}{additional arguments to be passed to the render function.}
}
\value{
None or the default image/video viewer displaying the animation
}
\description{
\code{animate_frames} creates an animation from a list of frames computed with \code{\link{frames_spatial}}.
}
\details{
An appropriate render function is selected depending on the file extension in \code{out_file}: For \code{.gif} files, \code{gifski::save_gif} is used, for any other (video) format, \code{av::av_capture_graphics} is used.
}
\examples{
library(moveVis)
library(move)

data("move_data", "basemap_data")
# align movement
m <- align_move(move_data, res = 4, unit = "mins")

# create spatial frames with frames_spatial:
r_list <- basemap_data[[1]]
r_times <- basemap_data[[2]]

\donttest{
frames <- frames_spatial(m, r_list = r_list, r_times = r_times, r_type = "gradient",
                         fade_raster = TRUE)

# customize
frames <- add_colourscale(frames, type = "gradient",
                          colours = c("orange", "white", "darkgreen"), legend_title = "NDVI")
frames <- add_northarrow(frames, position = "bottomleft")
frames <- add_scalebar(frames, colour = "white", position = "bottomright")

frames <- add_progress(frames)
frames <- add_timestamps(frames, m, type = "label")

# check available formats
suggest_formats()

# animate frames as GIF
animate_frames(frames, out_file = tempfile(fileext = ".gif"))

# animate frames as mov
animate_frames(frames, out_file = tempfile(fileext = ".gif"))
}
}
\seealso{
\code{\link{frames_spatial}} \code{\link{frames_graph}} \code{\link{join_frames}}
}
\author{
Jakob Schwalb-Willmann
}
