% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPositions.R
\name{getPositions}
\alias{getPositions}
\title{Get positions of genetic markers}
\usage{
getPositions(mpcrossMapped, markers)
}
\arguments{
\item{mpcrossMapped}{The \code{mpcross} object containing the map of interest}

\item{markers}{The markers for which to get the positions}
}
\value{
A named vector of numbers, with names corresponding to the selected genetic markers, and values corresponding to genetic positions.
}
\description{
Get positions of genetic markers, on their respective chromosomes
}
\details{
Get positions of genetic markers in cM, on their respective chromosomes
}
\examples{
map <- qtl::sim.map()
pedigree <- f2Pedigree(1000)
cross <- simulateMPCross(map = map, pedigree = pedigree, mapFunction = haldane, seed = 1)
mappedCross <- mpcrossMapped(cross = cross, map = map)
getPositions(mappedCross, c("D13M3", "DXM1", "DXM3"))
}
