(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     27614,        800]
NotebookOptionsPosition[     25973,        750]
NotebookOutlinePosition[     26496,        771]
CellTagsIndexPosition[     26453,        768]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"otherPairState", "[", "state_", "]"}], " ", ":=", " ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"state", ",", "2"}], "]"}], " ", "\[Equal]", " ", "0"}], ",", 
     RowBox[{"state", "-", "1"}], ",", 
     RowBox[{"state", "+", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"startRelevant2", "[", "state_", "]"}], " ", ":=", " ", 
   RowBox[{"state", " ", "-", " ", 
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"state", "+", "1"}], ",", " ", "2"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"startRelevant4", "[", "state_", "]"}], " ", ":=", " ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"state", " ", "\[GreaterEqual]", " ", "5"}], ",", " ", "5", ",", 
     " ", "1"}], "]"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"allPermutations", "[", "current_", "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"permutationsOf", ",", " ", "horizontal"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"permutationsOf", " ", "=", " ", 
      RowBox[{"PermutationReplace", "[", 
       RowBox[{"current", ",", " ", "permutations"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"horizontal", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"Join", "[", 
       RowBox[{"permutationsOf", ",", " ", "horizontal"}], "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"standardiseUsingPermutation", "=."}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Eight", "-", 
    RowBox[{"way", " ", "states"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"permutations", " ", "=", " ", 
     RowBox[{"GroupElements", "[", 
      RowBox[{"PermutationGroup", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"5", ",", "6"}], "}"}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"7", ",", "8"}], "}"}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"5", ",", "7"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"6", ",", "8"}], "}"}]}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "5"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"2", ",", "6"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"3", ",", "7"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"4", ",", "8"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"originalStates", " ", "=", " ", 
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"1", ",", "8"}], "]"}], ",", " ", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "Symmetries", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"standardiseUsingPermutation", "[", 
     RowBox[{"{", 
      RowBox[{"unique_", ",", " ", "standardised_", ",", " ", "remaining_"}], 
      "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"current", ",", "positions", ",", "permutationsOfCurrent"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"current", " ", "=", " ", 
        RowBox[{"First", "[", "remaining", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"permutationsOfCurrent", " ", "=", " ", 
        RowBox[{"allPermutations", "[", "current", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"positions", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{"unique", ",", "#1"}], "]"}], "&"}], "/@", 
         "permutationsOfCurrent"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Plus", "@@", 
           RowBox[{"(", 
            RowBox[{"Flatten", "[", "positions", "]"}], ")"}]}], " ", 
          "\[Equal]", " ", "0"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Append", "[", 
            RowBox[{"unique", ",", " ", "current"}], "]"}], ",", " ", 
           RowBox[{"Append", "[", 
            RowBox[{"standardised", ",", " ", "current"}], "]"}], ",", " ", 
           RowBox[{"Rest", "[", "remaining", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"unique", ",", " ", 
           RowBox[{"Append", "[", 
            RowBox[{"standardised", ",", " ", 
             RowBox[{"unique", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"Flatten", "[", "positions", "]"}], "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
           " ", 
           RowBox[{"Rest", "[", "remaining", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"recursiveResults", " ", "=", " ", 
     RowBox[{"Nest", "[", 
      RowBox[{"standardiseUsingPermutation", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", " ", 
         RowBox[{"{", "}"}], ",", " ", "originalStates"}], "}"}], ",", 
       RowBox[{"Length", "[", "originalStates", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"states", " ", "=", " ", 
     RowBox[{"recursiveResults", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"statesWithCounts", "=", 
    RowBox[{"Tally", "[", "states", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "statesWithCounts", "]"}], "\[IndentingNewLine]", 
   RowBox[{"states", " ", "=", " ", 
    RowBox[{"First", " ", "/@", "statesWithCounts"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rilMatrixFunction", "[", 
   RowBox[{"from_", ",", " ", "to_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "pair1", ",", " ", "pair2", ",", " ", "oneEach", ",", " ", 
      "pair1Matches", ",", " ", "pair2Matches", ",", " ", "sameMatches", ",", 
      " ", "oneEachMatches", ",", " ", "permutationsOfTo"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"permutationsOfTo", " ", "=", " ", 
      RowBox[{"allPermutations", "[", "to", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"pair1", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"from", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
        RowBox[{"from", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"pair2", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"from", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
        RowBox[{"from", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"pair1Matches", " ", "=", " ", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"pair1", ",", " ", "#1"}], "]"}], "]"}], "&"}], "/@", 
         "permutationsOfTo"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pair2Matches", " ", "=", " ", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"pair2", ",", " ", "#1"}], "]"}], "]"}], "&"}], "/@", 
         "permutationsOfTo"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sameMatches", " ", "=", " ", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"from", ",", " ", "#1"}], "]"}], "]"}], "&"}], "/@", 
         "permutationsOfTo"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"pair1Matches", " ", 
       FractionBox["1", "4"]}], " ", "+", " ", 
      RowBox[{"pair2Matches", " ", 
       FractionBox["1", "4"]}], " ", "+", " ", 
      RowBox[{"sameMatches", " ", 
       FractionBox["1", "2"]}]}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rilMatrix", " ", "=", " ", 
   RowBox[{"Outer", "[", 
    RowBox[{
    "rilMatrixFunction", ",", " ", "states", ",", " ", "states", ",", "1"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", 
  RowBox[{"rilMatrix", ",", " ", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"states", ",", " ", "states"}], "}"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "These", " ", "should", " ", "all", " ", "sum", " ", "to", " ", "1"}], 
  "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Plus", "@@", "#1"}], ")"}], "&"}], "/@", "rilMatrix"}], " ", "//",
   "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Check", " ", "that", " ", "eigen", " ", "decomposition", " ", "works"}], 
   ",", " ", 
   RowBox[{
   "difference", " ", "should", " ", "be", " ", "a", " ", "zero", " ", 
    "matrix"}]}], "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vectors", " ", "=", " ", 
   RowBox[{"Eigenvectors", "[", 
    RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"values", " ", "=", 
   RowBox[{"Eigenvalues", "[", 
    RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uniqueEigenValues", " ", "=", " ", 
   RowBox[{"DeleteDuplicates", "[", "values", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sortedEigenValues", " ", "=", " ", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "eigenIndex", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"vector", ",", "allResults", ",", " ", "allResultsIsZero"}], 
         "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"vector", " ", "=", " ", 
          RowBox[{"vectors", "[", 
           RowBox[{"[", 
            RowBox[{"eigenIndex", ",", "All"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"allResults", " ", "=", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", "currentEigenValue", "}"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"vector", " ", "currentEigenValue"}], " ", "-", " ", 
               RowBox[{"vector", ".", "rilMatrix"}]}], "//", 
              "FullSimplify"}]}], "]"}], "/@", "uniqueEigenValues"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"allResultsIsZero", " ", "=", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"AllTrue", "[", 
              RowBox[{"#1", ",", " ", 
               RowBox[{"Function", "[", 
                RowBox[{"x", ",", 
                 RowBox[{"x", "===", "0"}]}], "]"}]}], "]"}], ")"}], "&"}], "/@",
            "allResults"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Pick", "[", 
           RowBox[{"uniqueEigenValues", ",", " ", "allResultsIsZero"}], "]"}],
           "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
     "\[IndentingNewLine]", "]"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"1", ",", 
      RowBox[{"Length", "[", "states", "]"}]}], "]"}]}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Check", " ", "that", " ", "eigen", " ", "decomposition", " ", "has", " ", 
   "worked"}], "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"decomposed", " ", "=", " ", 
   RowBox[{
    RowBox[{"Inverse", "[", 
     RowBox[{"Eigenvectors", "[", 
      RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}], "]"}], " ", ".", 
    " ", 
    RowBox[{"DiagonalMatrix", "[", "sortedEigenValues", "]"}], ".", 
    RowBox[{"Eigenvectors", "[", 
     RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AllTrue", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"decomposed", " ", "-", " ", "rilMatrix"}], "//", 
     "FullSimplify"}], "]"}], ",", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#1", " ", "===", " ", "0"}], ")"}], "&"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Use", " ", "eigen", " ", "decomposition", " ", "to", " ", "take", " ", 
   "power"}], "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"power", " ", "=", " ", 
   RowBox[{
    RowBox[{"Inverse", "[", 
     RowBox[{"Eigenvectors", "[", 
      RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}], "]"}], " ", ".", 
    " ", 
    RowBox[{"MatrixPower", "[", 
     RowBox[{
      RowBox[{"DiagonalMatrix", "[", "sortedEigenValues", "]"}], ",", "d"}], 
     "]"}], ".", 
    RowBox[{"Eigenvectors", "[", 
     RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"withAICCombinedProbabilities", " ", "=", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox["8", "64"], ",", " ", 
      FractionBox["8", "64"], ",", " ", 
      FractionBox["16", "64"], ",", " ", 
      FractionBox["32", "64"]}], "}"}], ".", "power"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Check", " ", "that", " ", "the", " ", "limit", " ", "looks", " ", "right",
     " ", "in", " ", "the", " ", "case", " ", "of", " ", "infinite", " ", 
    "selfing"}], ",", " ", 
   RowBox[{"no", " ", "intercrossing"}]}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{"rilLimit", " ", "=", " ", 
  RowBox[{"Limit", "[", 
   RowBox[{"power", ",", " ", 
    RowBox[{"d", "\[Rule]", " ", "\[Infinity]"}], ",", " ", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"0", " ", "<", " ", "r"}], " ", "&&", " ", 
      RowBox[{"r", " ", "<", " ", 
       RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{"infiniteSelfing", " ", "=", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", " ", "1"}], "}"}], " ",
       ".", " ", "rilLimit"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"#1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ")"}], "&"}], "/@", 
       "statesWithCounts"}], ")"}]}], " ", "//", "FullSimplify"}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{"Pick", "[", 
  RowBox[{"states", ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#1", " ", "=!=", " ", "0"}], ")"}], "&"}], "/@", 
    "infiniteSelfing"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Probabilities", " ", "for", " ", "a", " ", "finite", " ", "number", " ", 
    "of", " ", "generations", " ", "of", " ", "selfing"}], ",", " ", 
   RowBox[{
    RowBox[{"no", " ", 
     RowBox[{"intercossing", ".", " ", "This"}], " ", "can", " ", "be", " ", 
     "worked", " ", "out", " ", "for", " ", "the", " ", "8"}], "-", 
    RowBox[{
    "way", " ", "design", " ", "just", " ", "based", " ", "on", " ", "the", 
     " ", "2"}], "-", 
    RowBox[{"way", " ", "design"}]}], ",", " ", 
   RowBox[{
   "and", " ", "it", " ", "should", " ", "match", " ", "the", " ", 
    "eigenvalue", " ", "calculation", " ", "above"}]}], " ", "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fromPaper2way", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["2", 
         RowBox[{"-", "d"}]]}], ")"}]}], ",", 
     SuperscriptBox["2", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "d"}]]}], "}"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", 
   RowBox[{"(", 
    RowBox[{"fromPaper2way", "*", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], ")"}]}], " ", "//", 
  "FullSimplify"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"permutationsF2", " ", "=", " ", 
   RowBox[{"GroupElements", "[", 
    RowBox[{"PermutationGroup", "[", 
     RowBox[{"{", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}], "}"}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"allPermutationsF2", "[", "current_", "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"permutationsOf", ",", " ", "horizontal"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"permutationsOf", " ", "=", " ", 
      RowBox[{"PermutationReplace", "[", 
       RowBox[{"current", ",", " ", "permutationsF2"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"horizontal", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"Join", "[", 
       RowBox[{"permutationsOf", ",", " ", "horizontal"}], "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"expected8wayFiniteSelfingMatrixFunction", " ", "=", " ", 
   RowBox[{"Function", "[", 
    RowBox[{"state", ",", " ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "toStates", ",", " ", "permutationsToStates", ",", " ", "result", ",",
          " ", "positions", ",", " ", "indices", ",", " ", "f2Permutations"}],
         "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"result", " ", "=", " ", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{"0", ",", " ", 
           RowBox[{"Length", "[", "states", "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "A"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], "}"}], "&"}], 
          "/@", "f2Permutations"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{"fromPaper2way", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "B"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], "}"}], "&"}], 
          "/@", "f2Permutations"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{"fromPaper2way", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"result", "//", "FullSimplify"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"expected8wayFiniteSelfingMatrix", " ", "=", 
   RowBox[{"expected8wayFiniteSelfingMatrixFunction", "/@", "states"}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Plus", "@@", "#1"}], ")"}], "&"}], "/@", 
   "expected8wayFiniteSelfingMatrix"}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"withoutAICCombinedProbabilities", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ".", 
    "expected8wayFiniteSelfingMatrix"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", "withoutAICCombinedProbabilities"}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Check", " ", "that", " ", "asymptotically", " ", "we", " ", "have", " ", 
   "the", " ", "right", " ", "values"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{"withoutAICCombinedProbabilities", ",", " ", 
    RowBox[{"d", "\[Rule]", "\[Infinity]"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", " ", 
     RowBox[{
      RowBox[{"0", " ", "<", " ", "r"}], " ", "&&", " ", 
      RowBox[{"r", " ", "<", " ", 
       RowBox[{"1", "/", "2"}]}]}]}]}], "]"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ")"}], "&"}], "/@", 
    "statesWithCounts"}], ")"}]}]], "Input"],

Cell[BoxData["withoutAICCombinedProbabilities"], "Input"],

Cell[BoxData[
 RowBox[{"withAICCombinedProbabilities", "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ")"}], "&"}], "/@", 
    "statesWithCounts"}], ")"}]}]], "Input"],

Cell[BoxData["withAICCombinedProbabilities"], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", "withAICCombinedProbabilities"}], "//", 
  "FullSimplify"}]], "Input"]
},
WindowSize->{1348, 710},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
TrackCellChangeTimes->False,
FrontEndVersion->"10.1 for Microsoft Windows (64-bit) (March 23, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 123, 3, 31, "Input"],
Cell[684, 25, 883, 25, 72, "Input"],
Cell[1570, 52, 989, 26, 112, "Input"],
Cell[2562, 80, 71, 1, 31, "Input"],
Cell[2636, 83, 5067, 130, 392, "Input"],
Cell[7706, 215, 2471, 65, 223, "Input"],
Cell[10180, 282, 418, 11, 52, "Input"],
Cell[10601, 295, 134, 4, 31, "Input"],
Cell[10738, 301, 172, 6, 31, "Input"],
Cell[10913, 309, 264, 8, 31, "Input"],
Cell[11180, 319, 2377, 61, 232, "Input"],
Cell[13560, 382, 151, 4, 31, "Input"],
Cell[13714, 388, 716, 20, 52, "Input"],
Cell[14433, 410, 147, 4, 31, "Input"],
Cell[14583, 416, 807, 23, 67, "Input"],
Cell[15393, 441, 295, 7, 31, "Input"],
Cell[15691, 450, 372, 9, 31, "Input"],
Cell[16066, 461, 725, 23, 52, "Input"],
Cell[16794, 486, 704, 16, 72, "Input"],
Cell[17501, 504, 612, 21, 68, "Input"],
Cell[18116, 527, 1308, 36, 132, "Input"],
Cell[19427, 565, 4580, 113, 352, "Input"],
Cell[24010, 680, 173, 4, 31, "Input"],
Cell[24186, 686, 194, 6, 31, "Input"],
Cell[24383, 694, 227, 6, 31, "Input"],
Cell[24613, 702, 121, 3, 31, "Input"],
Cell[24737, 707, 176, 4, 31, "Input"],
Cell[24916, 713, 551, 16, 31, "Input"],
Cell[25470, 731, 57, 0, 31, "Input"],
Cell[25530, 733, 251, 8, 31, "Input"],
Cell[25784, 743, 54, 0, 31, "Input"],
Cell[25841, 745, 128, 3, 31, "Input"]
}
]
*)

(* End of internal cache information *)
