% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProbabilities.R
\name{plotProbabilities}
\alias{plotProbabilities}
\title{Plot genetic composition across the genome}
\usage{
plotProbabilities(inputObject, positions, alleles, chromosomes)
}
\arguments{
\item{inputObject}{An object of class \code{mpcrossMapped} containing IBD genotype probabilities}

\item{positions}{The genetic positions at which to plot the composition}

\item{alleles}{The founder alleles which we are interested in.}

\item{chromosomes}{The chromosomes of to plot the composition.}
}
\value{
A ggplot object, suitable for display.
}
\description{
Plot genetic composition across the genome
}
\details{
Plot genetic composition of a population, across the genome. Composition is determined by using the IBD genotype probabilities, as computed by \code{\link{computeGenotypeProbabilities}}. The plot is produced by taking the average IBD genotype probability, for each founder allele and each genotpe position. Deviations from the expected proprotions (determined by the experimental design) may indicate non-standard genetic inheritance or selective pressure.
}
\examples{
data(simulatedFourParentData)
part1 <- subset(simulatedFourParentData, lines = 
	names(which(finals(simulatedFourParentData)[, 50] == 1)))
part2 <- subset(simulatedFourParentData, lines = 
	names(which(finals(simulatedFourParentData)[, 50] != 1)))
distorted <- subset(part1, lines = sample(nLines(part1), 100)) + part2
distortedMapped <- mpcrossMapped(distorted, map = simulatedFourParentMap)
probabilities <- computeGenotypeProbabilities(distortedMapped)
#Here the composition of the population reflects the fact that we have less of founder 1 than 
#    expected, at a specific point on the genome
plotProbabilities(probabilities)
#Go back to the undistorted data
undistortedMapped <- mpcrossMapped(simulatedFourParentData, map = simulatedFourParentMap)
probabilities <- computeGenotypeProbabilities(distortedMapped)
#Here the composition of the population reflects the expected inheritance; the trace 
#    corresponding to every founder is flat
plotProbabilities(probabilities)
}
