% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputationGenerics.R
\name{imputationData}
\alias{imputationData}
\alias{imputationData,imputed-method}
\alias{imputationData,geneticData-method}
\alias{imputationData,mpcrossMapped-method}
\title{Get out the IBD genotype imputation data}
\usage{
imputationData(object, ...)

\S4method{imputationData}{imputed}(object, ...)

\S4method{imputationData}{geneticData}(object, ...)

\S4method{imputationData}{mpcrossMapped}(object, ...)
}
\arguments{
\item{object}{The object from which to extract the IBD genotype imputation data}

\item{...}{Extra parameters. Currently only \code{"experiment"} is supported, letting the user extract the imputation data for a specific experiment.}
}
\value{
The IBD genotype imputation data.
}
\description{
Get out the IBD genotype imputation data
}
\details{
Extract the IBD genotype imputation data. The data takes the form of a matrix of values, with rows corresponding to genetic lines and columns corresponding to genetic positions. The genetic positions may include non-marker positions, so use \code{\link{imputationMap}} to find out the chromosome and position for every marker. 

Each value in the matrix represents the predicted genotype for that genetic line, at that position. In the case of completely inbred experiments, each value in the matrix represents the founders from which that allele is believed to be derived. In the case of experiments with residual heterozygosity, the possible genotypes include heterozygotes, and the interpretation of the values in the matrix is more complicated. Function \code{\link{imputationKey}} gives information about how the values in the matrix correspond to actual genotypes.
}
