% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getnu.R
\name{getnu}
\alias{getnu}
\title{Parameter Generator for nu}
\usage{
getnu(param, y, xx, offset, llstart, fsscale = 1, lambdalb = 1e-10,
  lambdaub = 1900, maxlambdaiter = 1000, tol = 1e-06)
}
\arguments{
\item{param}{numeric vector: the model coefficients & the current value of \code{nu}. 
It is assumed that \code{nu} is in the last position of \code{param}.}

\item{y}{numeric vector: response variable}

\item{xx}{numeric matrix: the explanatory variables}

\item{offset}{numeric vector: a vector of lenght equal to the number of cases}

\item{llstart}{numeric: current log-likelihood value}

\item{fsscale}{numeric: a scaling factor (generally >1) for the 
relaxed fisher scoring algorithm}

\item{lambdalb, lambdaub}{numeric: the lower and upper end points for the interval to be
searched for lambda(s).}

\item{maxlambdaiter}{numeric: the maximum number of iterations allowed to solve 
for lambda(s).}

\item{tol}{numeric: the convergence threshold. A lambda is said to satisfy the 
mean constraint if the absolute difference between the calculated mean and a fitted
values is less than tol.}
}
\value{
List containing the following:
\item{param}{the model coefficients & the updated \code{nu}}
\item{maxl}{the updated log-likelihood}
\item{fsscale}{the final scaling factor used}
}
\description{
A function that use the arguments of a \code{glm.cmp} call to generate a better initial 
\code{nu} estimate.
}
