% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_leslie_set.R
\name{rand_leslie_set}
\alias{rand_leslie_set}
\title{Generate a set of random Leslie Matrix Population Models}
\usage{
rand_leslie_set(
  n_models = 5,
  mortality_model = "gompertz",
  fertility_model = "step",
  mortality_params,
  fertility_params,
  fertility_maturity_params,
  dist_type = "uniform",
  output = "type1",
  scale_output = FALSE
)
}
\arguments{
\item{n_models}{An integer indicating the number of MPMs to generate.}

\item{mortality_model}{A character string specifying the name of the
mortality model to be used. Options are \code{gompertz}, \code{gompertzmakeham},
\code{exponential}, \code{siler}, \code{weibull}, and \code{weibullmakeham}. See
\code{model_mortality}. These names are not case-sensitive.}

\item{fertility_model}{A character string specifying the name of the
fertility model to be used. Options are \code{logistic}, \code{step},
\code{vonBertalanffy}, \code{normal} and \code{hadwiger.} See \code{?model_fertility}.}

\item{mortality_params}{A two-column dataframe with a number of rows equal to
the number of parameters in the mortality model. The required order of the
parameters depends on the selected \code{mortality_model} (see
\code{?model_mortality}):
\itemize{
\item For \code{gompertz} and \code{weibull}: \code{b_0}, \code{b_1}
\item For \code{gompertzmakeham} and \code{weibullmakeham}: \code{b_0}, \code{b_1},
\code{C}
\item For \code{exponential}: \code{C}
\item For \code{siler}: \code{a_0}, \code{a_1}, \code{C}, \code{b_0}, \code{b_1}
If \code{dist_type} is \code{uniform} these rows represent the lower and upper limits
of the random uniform distribution from which the parameters are drawn. If
\code{dist_type} is \code{normal}, the columns represent the mean and standard
deviation of a random normal distribution from which the parameter values
are drawn.
}}

\item{fertility_params}{A two-column dataframe with a number of rows equal to
the number of parameters in the fertility model. The required order of the
parameters depends on the selected \code{fertility_model} (see
\code{?model_mortality}):
\itemize{
\item For \code{logistic}: \code{A}, \code{k}, \code{x_m}
\item For \code{step}: \code{A}
\item For \code{vonBertalanffy}: \code{A}, \code{k}
\item For \code{normal}: \code{A}, \code{mu}, \code{sd}
\item For \code{hadwiger}: \code{a}, \code{b}, \code{C}
If \code{dist_type} is \code{uniform} these rows represent the lower and upper limits
of the random uniform distribution from which the parameters are drawn. If
\code{dist_type} is \code{normal}, the columns represent the mean and standard
deviation of a random normal distribution from which the parameter values
are drawn.
}}

\item{fertility_maturity_params}{A vector with two elements defining the
distribution from which age at maturity is drawn for the models. The models
will coerce fertility to be zero before this point. If \code{dist_type} is
\code{uniform} these values represent the lower and upper limits of the random
uniform distribution from which the parameters are drawn. If \code{dist_type} is
\code{normal}, the values represent the mean and standard deviation of a random
normal distribution from which the parameter values are drawn.}

\item{dist_type}{A character string specifying the type of distribution to
draw parameters from. Default is \code{uniform}. Supported types are \code{uniform}
and \code{normal}.}

\item{output}{Character string indicating the type of output. Output can be
one of the following types:
\itemize{
\item \code{Type1}: A \code{compadreDB} Object containing MPMs split into the submatrices
(i.e. A, U, F and C).
\item \code{Type2}: A \code{compadreDB} Object containing MPMs that are not split into
submatrices (i.e. only the A matrix is included).
\item \code{Type3}: A \code{list} of MPMs arranged so that each element of the list
contains a model and associated submatrices (i.e. the nth element contains
the nth A matrix alongside the nth U and F matrices).
\item \code{Type4}: A \code{list} of MPMs arranged so that the list contains 3 lists for
the A matrix and the U and F submatrices respectively.
\item \code{Type5}: A \code{list} of MPMs, including only the A matrix.
\item \code{Type6}: A \code{list} of life tables.

Default is \code{Type1}.
}}

\item{scale_output}{A logical argument. If \code{TRUE} the resulting MPMs or life
tables are scaled by adjusting fertility so that the population growth rate
(lambda) is 1. Default is \code{FALSE}.}
}
\value{
Returns a \code{CompadreDB} object or \code{list} containing MPMs or life
tables generated using the specified model with parameters drawn from
random uniform or normal distributions. The format of the output MPMs
depends on the arguments \code{output}. Outputs may optionally be scaled using
the argument \code{scale_output} to ensure a population growth rate (lambda) of
1.

If the output is a \code{CompadreDB} object, the parameters of the models used
to produce the MPM are included in the metadata.
}
\description{
Generates a set of Leslie matrix population models (MPMs) based on defined
mortality and fertility models, and using model parameters randomly drawn
from specified distributions.
}
\examples{

mortParams <- data.frame(
  minVal = c(0, 0.01, 0.1),
  maxVal = c(0.14, 0.15, 0.1)
)

fertParams <- data.frame(
  minVal = c(10, 0.5, 8),
  maxVal = c(11, 0.9, 10)
)

maturityParam <- c(0, 0)

rand_leslie_set(
  n_models = 5,
  mortality_model = "gompertzmakeham",
  fertility_model = "normal",
  mortality_params = mortParams,
  fertility_params = fertParams,
  fertility_maturity_params = maturityParam,
  dist_type = "uniform",
  output = "Type1"
)

}
\seealso{
Other Leslie matrices: 
\code{\link{make_leslie_mpm}()},
\code{\link{reorganise_matrices}()}
}
\author{
Owen Jones \href{mailto:jones@biology.sdu.dk}{jones@biology.sdu.dk}
}
\concept{Leslie matrices}
