% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_leslie_mpm.R
\name{make_leslie_mpm}
\alias{make_leslie_mpm}
\title{Create a Leslie matrix population model}
\usage{
make_leslie_mpm(
  survival = NULL,
  fecundity = NULL,
  n_stages = NULL,
  lifetable = NULL,
  split = FALSE
)
}
\arguments{
\item{survival}{a numeric value representing the survival probability of each
stage along the lower off-diagonal of the matrix, with the final value
being in the lower-right corner of the matrix. If only one value is
provided, this is applied to all survival elements.}

\item{fecundity}{a numeric vector of length n_stages representing the
reproductive output of each stage. If only one value is provided, this is
applied to all fecundity elements.}

\item{n_stages}{a numeric value representing the number of stages in the
matrix}

\item{lifetable}{a life table containing columns \code{px} (age-specific survival)
and \code{fecundity} (age-specific fecundity).}

\item{split}{a logical argument indicating whether the output matrix should
be split into separate A, U and F matrices (where A = U + F).}
}
\value{
A matrix of size n_stages x n_stages representing the Leslie matrix
}
\description{
The function creates a Leslie matrix from inputs of number of stages,
fecundity (the top row of the matrix), and survival probability (the value in
the sub-diagonal).
}
\examples{
make_leslie_mpm(
  survival = 0.5, fecundity = c(0.1, 0.2, 0.3),
  n_stages = 3, split = FALSE
)
make_leslie_mpm(
  survival = c(0.5, 0.6, 0.7), fecundity = c(0.1, 0.2, 0.3),
  n_stages = 3
)
make_leslie_mpm(
  survival = seq(0.1, 0.7, length.out = 4), fecundity = 0.1,
  n_stages = 4
)
make_leslie_mpm(
  survival = c(0.8, 0.3, 0.2, 0.1, 0.05), fecundity = 0.2,
  n_stages = 5
)

}
\references{
Caswell, H. (2001). Matrix Population Models: Construction,
Analysis, and Interpretation. Sinauer.

Leslie, P. H. (1945). On the use of matrices in certain population
mathematics. Biometrika, 33 (3), 183–212.

Leslie, P. H. (1948). Some Further Notes on the Use of Matrices in
Population Mathematics. Biometrika, 35(3-4), 213–245.
}
\seealso{
\itemize{
\item \code{\link[=model_survival]{model_survival()}} to model age-specific survival using mortality models.
\item \code{\link[=model_fecundity]{model_fecundity()}} to model age-specific reproductive output using various
functions.
}

Other Leslie matrices: 
\code{\link{rand_leslie_set}()},
\code{\link{reorganise_matrices}()}
}
\author{
Owen Jones \href{mailto:jones@biology.sdu.dk}{jones@biology.sdu.dk}
}
\concept{Leslie matrices}
