% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bezier.R
\name{bezier}
\alias{bezier}
\title{Bezier polynomials}
\usage{
bezier(..., indeterminate = "t")
}
\arguments{
\item{...}{either a sequence of points or a matrix/data frame of
points, see examples}

\item{indeterminate}{the indeterminate of the resulting
polynomial}
}
\value{
a mpoly object
}
\description{
Compute the Bezier polynomials of a given collection of points. 
Note that using \code{\link{as.function}} on the resulting Bezier
polynomials is made numerically stable by taking advantage of de
Casteljau's algorithm; it does not use the polynomial that is
printed to the screen.  See \code{\link{bezierFunction}} for
details
}
\examples{

p1 <- c(0,  0)
p2 <- c(1,  1)
p3 <- c(2, -1)
p4 <- c(3,  0)
bezier(p1, p2, p3, p4)


points <- data.frame(x = 0:3, y = c(0,1,-1,0))
bezier(points)


points <- data.frame(x = 0:2, y = c(0,1,0))
bezier(points)







# visualize the bernstein polynomials

library(ggplot2); theme_set(theme_bw())

s <- seq(0, 1, length.out = 101) 

## example 1
points <- data.frame(x = 0:3, y = c(0,1,-1,0))
(bezPolys <- bezier(points))

f <- as.function(bezPolys)
df <- as.data.frame(f(s))

ggplot(aes(x = x, y = y), data = df) + 
  geom_point(data = points, color = "red", size = 8) +
  geom_path(data = points, color = "red") +
  geom_path()
  
  
  
  
## example 1 with weights
f <- as.function(bezPolys, weights = c(1,5,5,1))
df <- as.data.frame(f(s))

ggplot(aes(x = x, y = y), data = df) + 
  geom_point(data = points, color = "red", size = 8) +
  geom_path(data = points, color = "red") +
  geom_path()
  
  
  
  
  
## example 2
points <- data.frame(x = 0:2, y = c(0,1,0))
(bezPolys <- bezier(points))
f <- as.function(bezPolys)
df <- as.data.frame(f(s))

ggplot(aes(x = x, y = y), data = df) + 
  geom_point(data = points, color = "red", size = 8) +
  geom_path(data = points, color = "red") +
  geom_path()




## example 3
points <- data.frame(x = c(-1,-2,2,1), y = c(0,1,1,0))
(bezPolys <- bezier(points))
f <- as.function(bezPolys)
df <- as.data.frame(f(s))

ggplot(aes(x = x, y = y), data = df) + 
  geom_point(data = points, color = "red", size = 8) +
  geom_path(data = points, color = "red") +
  geom_path()
  
  
  
  
## example 4
points <- data.frame(x = c(-1,2,-2,1), y = c(0,1,1,0))
(bezPolys <- bezier(points))
f <- as.function(bezPolys)
df <- as.data.frame(f(s))

ggplot(aes(x = x, y = y), data = df) + 
  geom_point(data = points, color = "red", size = 8) +
  geom_path(data = points, color = "red") +
  geom_path()
  
  
  
  
## example 5
qplot(speed, dist, data = cars)

s <- seq(0, 1, length.out = 201) 
p <- bezier(cars)
f <- as.function(p)
df <- as.data.frame(f(s))
qplot(speed, dist, data = cars) +
  geom_path(data = df, color = "red")



}
\author{
David Kahle
}
\seealso{
bezierFunction
}

