% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp2xy.R
\name{mp2xy}
\alias{mp2xy}
\title{Back-transform RAMAS Metapop coordinates}
\usage{
mp2xy(mp, r, cell.length, plot = TRUE)
}
\arguments{
\item{mp}{A character string containing the path to a RAMAS Metapop .mp file.}

\item{r}{Either a character string containing the path to any of the raster
files that were used by RAMAS Spatial Data for patch identification, or a
\code{Raster*} object that was used for that purpose.}

\item{cell.length}{Numeric. The cell length of the grid, as specified in 
RAMAS Spatial Data (note: this may be different to the native resolution of
the grids).}

\item{plot}{Logical. Should the points be plotted? If \code{r} is a 
\code{Raster*} object with more than one layer, the first layer will be 
plotted.}
}
\value{
A \code{data.frame} containing the names of all populations referred 
  to in the .mp file, as well as their coordinates (in both Metapop and 
  original coordinate systems). If \code{plot} is \code{TRUE}, a plot of the 
  raster layer, \code{r}, overlaid with points for all populations in the 
  metapopulation, is also produced.
}
\description{
Extracts population coordinates from a RAMAS Metapop .mp file, and converts 
them back to the coordinate system of the original habitat suitability grids 
(i.e. the grids supplied to the RAMAS patch-identification module, patch.exe 
or, in more recent versions of RAMAS GIS, SpatialData.exe).
}
\note{
\code{mptools} has been tested with outputs generated by RAMAS Metapop 
  version 5, and may produce unexpected results for other versions. A warning
  is issued if the user attempts to access files originating from other 
  versions of RAMAS Metapop. It is advised to verify that the returned 
  coordinates are sensible by referring to the plot that is returned by this 
  function.
}
\examples{
mp <- system.file('example.mp', package='mptools')
r <- system.file('example_001.tif', package='mptools')
coords <- mp2xy(mp, r, 9.975)
}
\seealso{
\code{\link{mp2sp}}
}

