% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_geojson.R
\name{mr_geojson}
\alias{mr_geojson}
\title{Get a Marineregions geojson file}
\usage{
mr_geojson(key = NULL, name = NULL, maxFeatures = 50, ...)
}
\arguments{
\item{key}{(character) Region key, of the form \code{x:y}, where
\code{x} is a namespace (e.g., \code{MarineRegions}), and \code{y} is
a region (e.g., \code{eez_33176})}

\item{name}{(character) Region name, if you supply this, we search
against titles via \code{\link[=mr_names]{mr_names()}} function}

\item{maxFeatures}{(integer) Number of features to return. Default: \code{50}}

\item{...}{Curl options passed on to \code{\link[httr:GET]{httr::GET()}}}
}
\value{
an S3 class of type \code{mr_geojson}, just a thin wrapper around
a list. The list has names:
\itemize{
\item type (character) - the geojson type (e.g., FeatureCollection)
\item totalFeatures (integer) - the
\item features (list) - the features, with slots for each feature: type,
id, geometry, geometry_name, and properties
\item crs (list) - the coordinate reference system
\item bbox (list) - the bounding box that encapsulates the object
}
}
\description{
Get a Marineregions geojson file
}
\examples{
\dontrun{
# by key
res1 <- mr_geojson(key = "Morocco:dam")

# by name -- not working right now

if (requireNamespace("geojsonio")) {
  library("geojsonio")
  as.json(unclass(res1)) \%>\% map_leaf

  # MEOW - marine ecoregions
  as.json(unclass(mr_geojson("Ecoregions:ecoregions"))) \%>\% map_leaf()
}
}
}
