% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_gaz_geom.R
\name{gaz_geometry}
\alias{gaz_geometry}
\alias{gaz_geometry.numeric}
\alias{gaz_geometry.mr_df}
\title{Get the geometries of a Marine Regions Geo-Object}
\usage{
gaz_geometry(x, ...)

\method{gaz_geometry}{numeric}(x, ...)

\method{gaz_geometry}{mr_df}(x, ...)
}
\arguments{
\item{x}{object to retrieve the geometries from. Accepted:
\itemize{
\item (integer) A valid Marine Regions Gazetteer Identifier (\link{MRGID})
\item A data frame retrieved with \link{mregions2} via its functions \code{\link[=gaz_search]{gaz_search()}},
\code{\link[=gaz_search_by_source]{gaz_search_by_source()}}, \code{\link[=gaz_search_by_type]{gaz_search_by_type()}} or \code{\link[=gaz_relations]{gaz_relations()}}. See details.
}}

\item{...}{
  Arguments passed on to \code{\link[=gaz_rest_geometries]{gaz_rest_geometries}}
  \describe{
    \item{\code{format}}{(character) The preferred output format. One of:
\itemize{
\item "sfc": Simple Feature geometry object. See 'sf'
\item "wkt": Geometry representation as \href{https://en.wikipedia.org/wiki/Well-known_text}{Well-Known Text}
\item "rdf": Geometry as an object of class 'rdf". See 'rdflib'
}

Default is "sfc"}
    \item{\code{multipart}}{(logical) Some Geo-Objects are compound of more than one part.
\itemize{
\item If FALSE, returns singlepart geometries (e.g. POLYGON, LINESTRING)
\item If TRUE (default), returns multipart geometries (e.g. MULTIPOLYGON, MULTILINESTRING)
}}
  }}
}
\value{
A sfc object (default), a sf data frame, a WKT string or an RDF object
}
\description{
Get the geometries of a Marine Regions Geo-Object
}
\details{
You can pass the output of most \verb{gaz_*} functions to \code{gaz_geometry()} to retrieve the
geometry the gazetteer entry. The data frame is then transformed into a \link[sf:sf]{sf::sf} object.
\subsection{Developer info}{

This is done in the method \code{\link[=gaz_geometry.mr_df]{gaz_geometry.mr_df()}}. \code{mr_df} is a class defined in
this package to ensure the data frame passed to gaz_geometry has a variable with \link{MRGID}.
}
}
\examples{
\donttest{
gaz_geometry(3293)
gaz_geometry(3293, format = "wkt")
gaz_geometry(3293, format = "rdf")

gaz_search(3293) |> gaz_geometry()
}
}
