% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_parallel.R
\name{parallel_mrgsim_d}
\alias{parallel_mrgsim_d}
\alias{future_mrgsim_d}
\alias{mc_mrgsim_d}
\alias{fu_mrgsim_d}
\alias{fu_mrgsim_d0}
\title{Simulate a data set in parallel}
\usage{
future_mrgsim_d(
  mod,
  data,
  nchunk = 4,
  ...,
  .as_list = FALSE,
  .p = NULL,
  .dry = FALSE,
  .seed = TRUE,
  .parallel = TRUE
)

mc_mrgsim_d(
  mod,
  data,
  nchunk = 4,
  ...,
  .as_list = FALSE,
  .p = NULL,
  .dry = FALSE,
  .seed = NULL,
  .parallel = TRUE
)

fu_mrgsim_d(
  mod,
  data,
  nchunk = 4,
  ...,
  .as_list = FALSE,
  .p = NULL,
  .dry = FALSE,
  .seed = TRUE,
  .parallel = TRUE
)

fu_mrgsim_d0(..., .dry = TRUE)
}
\arguments{
\item{mod}{The mrgsolve model object see \link[mrgsolve:mrgmod-class]{mrgsolve::mrgmod}.}

\item{data}{Data set to simulate; see \code{\link[mrgsolve:data_set]{mrgsolve::data_set()}}.}

\item{nchunk}{Number of chunks in which to split the data set}

\item{...}{Passed to \code{\link[=mrgsim_d]{mrgsim_d()}}.}

\item{.as_list}{If \code{TRUE} a list is return; otherwise (default) a data frame}

\item{.p}{Post processing function executed on the worker; arguments should
be (1) the simulated output (2) the model object.}

\item{.dry}{If \code{TRUE} neither the simulation nor the post processing will
be done.}

\item{.seed}{Passed to \code{\link[=future_lapply]{future_lapply()}} as \code{future.seed}.}

\item{.parallel}{if \code{FALSE}, the simulation will not be parallelized; this is
intended for debugging and testing use only.}
}
\value{
A data frame or list of simulated data.
}
\description{
Use \code{\link[=future_mrgsim_d]{future_mrgsim_d()}} to simulate with the \code{future} package.  Use
\code{\link[=mc_mrgsim_d]{mc_mrgsim_d()}} to simulate with \code{parallel::mclapply}.
}
\examples{

mod <- mrgsolve::house()

data <- mrgsolve::expand.ev(amt = seq(10))

out <- future_mrgsim_d(mod, data, nchunk = 2)

}
\seealso{
\code{\link[=future_mrgsim_ei]{future_mrgsim_ei()}}
}
