% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcache.R, R/mread.R
\name{mread_cache}
\alias{mread_cache}
\alias{mread}
\title{Read a model specification file.}
\usage{
mread_cache(model, project = getwd(), code = NULL, soloc = tempdir(),
  quiet = FALSE, preclean = FALSE, ...)

mread(model = character(0), project = getwd(), code = NULL, udll = TRUE,
  ignore.stdout = TRUE, raw = FALSE, compile = TRUE, audit = TRUE,
  quiet = getOption("mrgsolve_mread_quiet", FALSE), check.bounds = FALSE,
  warn = TRUE, soloc = tempdir(), preclean = FALSE, ...)
}
\arguments{
\item{model}{model name}

\item{project}{location of the model specification file an any headers to be included}

\item{code}{a character string with model specification code to be used instead of a model file}

\item{soloc}{directory where model shared object is stored}

\item{quiet}{don't print messages when compiling}

\item{preclean}{logical; if \code{TRUE}, compilation artifacts are cleaned up first}

\item{...}{passed along}

\item{udll}{use unique name for shared object}

\item{ignore.stdout}{passed to system call for compiling model}

\item{raw}{if TRUE, return a list of raw output}

\item{compile}{logical; if \code{TRUE}, the model will be built}

\item{audit}{check the model specification file for errors}

\item{check.bounds}{check boundaries of parameter list}

\item{warn}{logical; if \code{TRUE}, print warning messages that may arise}
}
\description{
\code{mread} reads and parses a \code{mrgsolve} model specification file, builds the model, and returns 
a model object for simulation.
}
\section{Model Library}{


\code{mrgsolve} comes bundled with several precoded PK, PK/PD, and other systems models
that are accessible via the \code{mread} interface.  

Models available in the library include:

\itemize{
  \item PK models: \code{pk1cmt}, \code{pk2cmt}, \code{pk3cmt}, \code{tmdd}
  \item PKPD models: \code{irm1}, \code{irm2}, \code{irm3}, \code{irm4}, \code{emax}, \code{effect}
  \item Other models: \code{viral1}, \code{viral2}
}

When the library model is accessed, \code{mrgsolve} will compile and load
the model as you would for any other model.  It is only necessary to 
reference the correct model name and point the \code{project} argument
to the \code{mrgsolve} model library location via \code{\link{modlib}}.

For more details, see \code{\link{modlib_pk}}, \code{\link{modlib_pkpd}}, 
\code{\link{modlib_tmdd}}, \code{\link{modlib_viral}}, and \code{\link{modlib_details}}
for more information about the state variables and parameters in each model.
}

\examples{


code <- '
$PARAM CL = 1, VC = 5
$CMT CENT
$ODE dxdt_CENT = -(CL/VC)*CENT;
'

mod <- mcode("ex_mread",code)

mod

mod \%>\% init(CENT=1000) \%>\% mrgsim \%>\% plot


mod <- mread("irm3", modlib())

mod

}
