% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix_helpers}
\alias{matrix_helpers}
\alias{bmat}
\alias{cmat}
\alias{dmat}
\title{Create matrices from vector input}
\usage{
bmat(..., correlation = FALSE, digits = -1)

cmat(..., digits = -1)

dmat(...)
}
\arguments{
\item{...}{matrix data}

\item{correlation}{logical; if TRUE, off-diagonal elements are assumed 
to be correlations and converted to covariances}

\item{digits}{if greater than zero, matrix is passed to signif (along 
with digits) prior to returning}
}
\description{
Create matrices from vector input
}
\details{
\code{bmat} makes a block matrix.  \code{cmat} makes a correlation matrix. 
\code{dmat} makes a diagonal matrix.
}
\examples{

dmat(1,2,3)/10

bmat(0.5,0.01,0.2)

cmat(0.5, 0.87,0.2)

}
\seealso{
\code{\link{as_bmat}}

\code{\link{as_dmat}}
}
