% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msaenet-inspect.R
\name{msaenet.nzv.all}
\alias{msaenet.nzv.all}
\title{Get Indices of Non-Zero Variables in All Steps}
\usage{
msaenet.nzv.all(object)
}
\arguments{
\item{object}{An object of class \code{msaenet} produced
by \code{\link{aenet}}, \code{amnet}, \code{asnet},
\code{\link{msaenet}}, \code{\link{msamnet}}, or \code{\link{msasnet}}.}
}
\value{
List containing indices vectors of non-zero variables in all steps.
}
\description{
Get the indices of non-zero variables in all steps from msaenet model objects.
}
\examples{
dat <- msaenet.sim.gaussian(
  n = 150, p = 500, rho = 0.6,
  coef = rep(1, 5), snr = 2, p.train = 0.7,
  seed = 1001
)

msaenet.fit <- msaenet(
  dat$x.tr, dat$y.tr,
  alphas = seq(0.2, 0.8, 0.2),
  nsteps = 3L, seed = 1003
)

msaenet.nzv.all(msaenet.fit)
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
