% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_data_color.R
\name{chart_data_size}
\alias{chart_data_size}
\title{Modify symbol size}
\usage{
chart_data_size(x, values)
}
\arguments{
\item{x}{an \code{ms_chart} object.}

\item{values}{\code{double(num of series)}: a set of size values to map data values to.
It is a named vector, the values will be matched based on the names.
If it contains only one size, this size will be associated to all existing series.}
}
\description{
Specify mappings from levels in the data to displayed size of symbols.
}
\examples{
my_scatter <- ms_scatterchart(data = iris, x = "Sepal.Length",
  y = "Sepal.Width",  group = "Species")
my_scatter <- chart_data_fill(my_scatter,
  values = c(virginica = "#6FA2FF", versicolor = "#FF6161", setosa = "#81FF5B") )
my_scatter <- chart_data_stroke(my_scatter,
  values = c(virginica = "black", versicolor = "black", setosa = "black") )
my_scatter <- chart_data_symbol(my_scatter,
  values = c(virginica = "circle", versicolor = "diamond", setosa = "circle") )
my_scatter <- chart_data_size(my_scatter,
  values = c(virginica = 20, versicolor = 16, setosa = 20) )
}
\seealso{
\code{\link{chart_data_fill}}, \code{\link{chart_data_stroke}}, \code{\link{chart_data_symbol}}
}
