\name{iterGlm}
\alias{iterGlm}
\title{ iterative generalized linear regression }
\description{
 Fit the Poisson linear model by iteratively fitting glm and gene expression levels.
}
\usage{
iterGlm(data, thrd = 0.01, max_iter = 10)
}
\arguments{
  \item{data}{ the data frame generated by \code{expData.R} }
  \item{thrd}{ the threshould of improvement of R squared }
  \item{max_iter}{ maximum number of iterations }
}
\value{
 an glm structure. Summarize it will list the coefficients and their p-values.
}
\examples{
 data(g1_part) # for real data, please use read.csv, like g1 <- read.csv("g1.csv")
 data <- expData(g1_part, 2, 3)

 data.glm <- iterGlm(data)
 summary(data.glm)
}
\keyword{ models }
\keyword{ regression }
