% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negent.R
\name{negent}
\alias{negent}
\title{Estimating negative entropy}
\usage{
negent(x, K = ceiling(log2(length(x)) + 1))
}
\arguments{
\item{x}{The \eqn{n}-vector of observations.}

\item{K}{The number of bins to use in the histogram.}
}
\value{
The value of the estimated negentropy.
}
\description{
Calculates the histogram-based estimate (A.2) of the negentropy,
\deqn{Negent(g) = (1/2)*(1 + log(2\pi \sigma ^2)) - Entropy(g), }
for a vector of observations.
}
\examples{
# TBA - Submit a PR!
}
\seealso{
\code{\link{negent2D}},\code{\link{negent3D}}
}
