% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{generate.complete.graph}
\alias{generate.complete.graph}
\title{Generates a complete graph}
\usage{
generate.complete.graph(nodes.list, distance.matrix)
}
\arguments{
\item{nodes.list}{A vector with a subset of objects (nodes) of the data matrix for which the complete graph must be generated.}

\item{distance.matrix}{A distance matrix between each pair of elements in \code{nodes.list}. It is used as the edges costs to generate the complete graph.}
}
\value{
\item{edges.complete.graph}{A object of class "data.frame" with three columns (\emph{from}, \emph{to}, \emph{costs}) representing the edges costs of complete graph. For instance:}
\tabular{llc}{
  \emph{from} \tab  \emph{to} \tab  \emph{costs}\cr
 1 \tab 2 \tab 1.60\cr
  1 \tab 3 \tab 0.08\cr
  1 \tab 4 \tab 1.21\cr
  ... \tab ... \tab ...\cr
  n-1 \tab n \tab ...\cr
}
}
\description{
This function generates a complete graph assigning costs to the edges according to \code{distance.matrix}.
}
\examples{

set.seed(1987)

##Generates a data matrix of dimension 50X13

n=50; m=13
x <- matrix(runif(n*m, min = -5, max = 10), nrow=n, ncol=m)

##Computes a distance matrix of x.

library("amap")
d <- base::as.matrix(amap::Dist(x, method="euclidean"))

##Generates complete graph (CG)

cg <- generate.complete.graph(1:nrow(x),d)

head(cg)

##Visualizing CG graph
library("igraph")
cg.network=igraph::graph.adjacency(d, mode="undirected", weighted=TRUE)
plot(cg.network, edge.label=round(E(cg.network)$weight, 2), main="Complete Graph")

}
\author{
Mario Inostroza-Ponta, Jorge Parraga-Alava, Pablo Moscato
}
\keyword{complete}
\keyword{graph}
