% wll-15-03-2007:
%
\name{feat.rank.re}
\alias{feat.rank.re}

\title{
Feature Ranking with Resampling Method
}

% ----------------------------------------------------------------------------
\description{
Feature selection with resampling method.
}

% ----------------------------------------------------------------------------
\usage{
  feat.rank.re(x,y,method=,pars = valipars(),tr.idx=NULL,...)
}

% ----------------------------------------------------------------------------
\arguments{
  \item{x}{
    A matrix or data frame containing the explanatory variables.
  }
  \item{y}{
    A factor specifying the class for each observation.
  }
  \item{method}{
    Feature selection method to be used. For each method used in this 
    function, the output must be a list including two components, \code{fs.rank}
    (rank scores of features) and \code{fs.order}(feature orders in descending order).
  }             
  \item{pars}{
    A list of resampling scheme method such as \emph{Leave-one-out cross-validation}, 
    \emph{Cross-validation}, \emph{Bootstrap} and \emph{Randomised validation (holdout)}.
  	See \code{\link{valipars}} for details.
  }
  \item{tr.idx}{
  User defined index of training samples. Can be generated by \code{trainind}.
  }
  \item{\dots}{Additional parameters to \code{method}.}
}

% ----------------------------------------------------------------------------
\value{
  A list with components:
  \item{method}{Feature selection method used.}
  \item{fs.rank}{A vector of final feature ranking list.}
  \item{fs.order}{A vector of final feature order from best to worst.}
  \item{rank.list}{Feature rank lists of all computation.}
  \item{order.list}{Feature order lists of all computation.}
  \item{pars}{Resampling parameters.}
  \item{tr.idx}{Index of training samples.}
  \item{all}{All results come from re-sampling.}
}

% ----------------------------------------------------------------------------
\author{
  Wanchang Lin 
}

\seealso{
  \code{\link{valipars}}, \code{\link{feat.freq}}, \code{\link{frankvali}}
}

% ----------------------------------------------------------------------------
\examples{
## prepare data set
data(abr1)
cls <- factor(abr1$fact$class)
dat <- abr1$pos
## dat <- abr1$pos[,110:1930]

## fill zeros with NAs
dat <- mv.zene(dat)

## missing values summary
mv <- mv.stats(dat, grp=cls) 
## mv    ## View the missing value pattern

## filter missing value variables
## dim(dat)
dat <- dat[,mv$mv.var < 0.15]
## dim(dat)

## fill NAs with mean
dat <- mv.fill(dat,method="mean")

## log transformation
dat <- preproc(dat, method="log10")

## select class "1" and "2" for feature ranking
ind <- which(cls==1 | cls==2)
x   <- dat[ind,,drop=FALSE] 
y   <- cls[ind, drop=TRUE]   

## feature selection
pars   <- valipars(sampling="boot",niter=2,nreps=5)
tr.idx <- trainind(y,pars=pars)

z      <- feat.rank.re(x,y,method="fs.auc",pars = pars)
names(z)
               
}

\keyword{classif}
