% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_html.R
\name{add_colored_box}
\alias{add_colored_box}
\title{Add a box with specified color in an R Markdown file.}
\usage{
add_colored_box(
  type = "blue-default",
  label = "",
  info = "place details here using info option",
  bgcolor = NULL,
  width = 0.5,
  halign = "c",
  top = FALSE
)
}
\arguments{
\item{type}{One of:
- \code{NULL} for no default color or label
- 'blue-default' for a steel-blue box
- 'gray-info' for a gray box
- 'blue-info' for a blue box
- 'green-remainder' for a green box
- 'yellow-warning' for a yellow box
- 'red-stop' for a red box}

\item{label}{One of:
- \code{NULL} for no label if type is NULL or using label set by type
- A string shown on the top of box}

\item{info}{A string including the main message of the box}

\item{bgcolor}{NA or a length 3 vector with integer elements between 0 to 255}

\item{width}{NA or a number between 0.25 to 0.95}

\item{halign}{One of:
- \code{NA} for center aligned
- 'c' for center aligned
- 'r' for right aligned}

\item{top}{One of:
- NA
- \code{FALSE} for inline
- \code{TRUE} for top-of-page}
}
\description{
\code{add_colored_box} returns a box component generated by \code{htmltools}
with specified color and styles.
}
\examples{
add_colored_box( type='blue-default', info='the document include information regarding...')

}
