% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtag.R
\name{aggregate.qtag.long}
\alias{aggregate.qtag.long}
\alias{aggregate.qtag.wide}
\title{Aggregate/Summarise a qualifier/tag structure}
\usage{
\method{aggregate}{qtag.long}(x, ..., force = TRUE)

\method{aggregate}{qtag.wide}(x, ..., force = TRUE)
}
\arguments{
\item{x}{A \link{qtag} object}

\item{...}{A parameter including at least one unnamed parameter for summarising values.
Additional parameters may be used for aggregating a long format.}

\item{force}{Use \code{force=FALSE} to only aggregate if the object is not already summarised.}
}
\value{
A (possibly unchanged) \code{qtag} object
}
\description{
Summarises a \link{qtag} object such that one value exists for every unique
qualifier combination. This is useful for summarising replicates.
}
\examples{
data(pocmaj)
pocmajqt <- as.qtag(pocmaj, id.vars=c("core", "depth"))
aggregate(pocmajqt)
aggregate(pocmajqt, mean)
aggregate(long(pocmajqt), mean, sd, length)

}

