% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{parallel.melt}
\alias{parallel.melt}
\title{Melt multiple sets of columns in parallel}
\usage{
parallel.melt(x, id.vars, ..., variable.name = "param",
  factorsAsStrings = TRUE)
}
\arguments{
\item{x}{A data.frame}

\item{id.vars}{vector of ID variable names}

\item{...}{Named arguments specifying the \code{measure.vars} to be stored to the
column name specified.}

\item{variable.name}{Column name to use to store variables}

\item{factorsAsStrings}{Control whether factors are converted to character when melted as
measure variables.}
}
\value{
A \code{qtag.long} object
}
\description{
Essentially this is a wrapper around \code{reshape2::melt.data.frame} that
is able to \code{cbind} several melt operations. This is useful when a wide
data frame contains uncertainty or flag information in paired columns.
}
\examples{
data(pocmajsum)
parallel.melt(pocmajsum,
              id.vars=c("core", "depth"),
              values=c("Ca", "Ti", "V"),
              err=c("Ca_sd", "Ti_sd", "V_sd"))

}

