% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardSimplex_exp_sum.R
\docType{class}
\name{standardSimplex_exp_sum-class}
\alias{standardSimplex_exp_sum-class}
\alias{standardSimplex_exp_sum}
\title{An S4 class to represent the function \eqn{\exp(-c(x_1 + \ldots + x_n))} on \eqn{T_n}}
\description{
Implementation of the function
\deqn{f \colon T_n \to (0,\infty),\, \vec{x} \mapsto f(\vec{x}) = \exp(-c(x_1 + \ldots + x_n)),}
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{T_n = \{\vec{x} \in \R^n : x_i\geq 0, \Vert \vec{x} \Vert_1 \leq 1\}} and \eqn{c>0} is a constant.
The integral is known to be
\deqn{\int_{T_n} f(\vec{x}) d\vec{x} = \frac{\Gamma(n)-\Gamma(n,c)}{\Gamma(n)c^n},}
where \eqn{\Gamma(s,x)} is the incomplete gamma function.
}
\details{
The instance needs to be created with two parameters representing the dimension \eqn{n} and the parameter \eqn{c>0}.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}

\item{\code{coeff}}{A strictly positive number representing the constant}
}}

\examples{
n <- as.integer(3)
f <- new("standardSimplex_exp_sum",dim=n,coeff=1)
}
