% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitCube_cos2.R
\docType{class}
\name{unitCube_cos2-class}
\alias{unitCube_cos2-class}
\alias{unitCube_cos2}
\title{An S4 class to represent the function \eqn{(\cos(\vec{x}\cdot\vec{v}))^2} on \eqn{[0,1]^n}}
\description{
Implementation of the function
\deqn{f \colon [0,1]^n \to [0,1],\, \vec{x} \mapsto f(\vec{x}) = (\cos(\vec{x}\cdot\vec{v}))^2,}
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{C_n = [0,1]^n} and \eqn{\vec{v}} is a \eqn{n}-dimensional parameter vector where each entry is different from \eqn{0}.
The integral is known to be
\deqn{\int_{C_n} f(\vec{x}) d\vec{x} = \frac{1}{2}+\frac{1}{2}\cos(\sum_{j=1}^{n}v_j)\prod_{j=1}^{n}\frac{\sin(v_j)}{v_j}.}
}
\details{
The instance needs to be created with two parameters representing the dimension \eqn{n} and the \eqn{n}-dimensional parameter vector where each entry is different from \eqn{0}.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}

\item{\code{coeffs}}{A vector of non-zero parameters}
}}

\examples{
n <- as.integer(3)
f <- new("unitCube_cos2",dim=n, coeffs=c(-1,2,-2))
}
