% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bop}
\alias{bop}
\title{Bloc Operation in Place}
\usage{
bop(dst, mv, sop, src)
}
\arguments{
\item{dst}{A numeric array, destination}

\item{mv}{An integer vector or matrix, describe margins to operate on}

\item{sop}{A string, describes an operator to apply}

\item{src}{A numeric array, source (may be replicated to fit the size of dst)}
}
\value{
None
}
\description{
src array is added (if sop=="+=") to dst[...]
or any other manipulation is made according to sop parameter
Both arrays are supposed to be of type 'double'
The operation is done 'in place' without new memory allocation for dst
src is reshaped and possibly replicated to fit the designated block of dst.
mv can be: \itemize{
 \item a 1 or 3 component vector describing the block: 1-margin number of dst, 2-offset, 3-length
   if only the margin is present than offest is 0 and length is the total length of this margin
 \item a matrix of indexes. Its column number must be equal to the length(dim(dst)))
   each row of this matrix is a multidimensional index in dst array.
}
sop is one off: "=" (copy src to dst[]), "+=", "-=", "*=", "/="
}
\examples{
a=matrix(1, 3, 3) # 3x3 matrix of 1's
b=1:3
bop(a, 2, "+=", b) # a += b, here b will be repeated
a
#      [,1] [,2] [,3]
# [1,]    2    2    2
# [2,]    3    3    3
# [3,]    4    4    4
}
