% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdm.R
\name{exhaustive.search}
\alias{exhaustive.search}
\title{A function for an exhaustive search, calculates the optimum value of the discount factor.}
\usage{
exhaustive.search(Data, node, nbf = 15, delta = seq(0.5, 1, 0.01),
  cpp = TRUE, priors = priors.spec())
}
\arguments{
\item{Data}{Dataset with dimension number of time points T x Number of nodes Nn.}

\item{node}{The node to find parents for.}

\item{nbf}{Log Predictive Likelihood will sum from (and including) this time point.}

\item{delta}{a vector of potential values for the discount factor.}

\item{cpp}{boolean true (default): fast C++ implementation, false: native R code.}

\item{priors}{list with prior hyperparameters.}
}
\value{
model.store a matrix with the model, LPL and chosen discount factor for all possible models.
runtime an estimate of the run time of the function, using proc.time().
}
\description{
A function for an exhaustive search, calculates the optimum value of the discount factor.
}
